% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KICH.R
\docType{data}
\name{kich}
\alias{kich}
\title{KICH dataset}
\format{
An object of class \code{matrix} with 66 rows and 40 columns.
}
\source{
\url{https://portal.gdc.cancer.gov/}
}
\usage{
kich
}
\description{
Mutation data from TCGA kidney chromophobe cohort (KICH). 
Mutations are picked according to q-value computed 
by MutSigCV. Only mutations with q-value of less than
0.05 for any of kidney cancer subtypes (KIRC, KIRP, KICH) are included.
}
\details{
{
Each variable represents a gene. If in sample i gene j contains a mutation, than j-th element in 
row i equals 1, and 0 otherwise.
The rows are named according to sample names in TCGA.
The columns are named according to gene symbols.
}
}
\references{
\url{https://portal.gdc.cancer.gov/}

\url{http://firebrowse.org/iCoMut/?cohort=kich}

Lawrence, M. et al. Mutational heterogeneity in cancer and the search for new cancer-associated genes. Nature 499, 214-218 (2013).
}
\keyword{datasets}
