% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Other_Indices.R
\name{PUC}
\alias{PUC}
\title{PUC}
\usage{
PUC(Lambda)
}
\arguments{
\item{Lambda}{is a matrix of factor loadings}
}
\value{
\code{numeric}
}
\description{
\code{PUC} computes the proportion of uncontaminated correlations for a bifactor mode
}
\details{
\code{PUC} is called by \code{\link{bifactorIndices}} and \code{\link{bifactorIndicesMplus}},
which are the only functions in this package intended for casual users
}
\examples{
Lambda <- matrix(c(.82, .10,   0,   0,
                   .77, .35,   0,   0,
                   .79, .32,   0,   0,
                   .66, .39,   0,   0,
                   .51,   0, .71,   0,
                   .56,   0, .43,   0,
                   .68,   0, .13,   0,
                   .60,   0, .50,   0,
                   .83,   0,   0, .47,
                   .60,   0,   0, .27,
                   .78,   0,   0, .28,
                   .55,   0,   0, .75),
                   ncol = 4, byrow = TRUE)
colnames(Lambda) <- c("General", "PS", "HA", "SA")
PUC(Lambda)


}
\seealso{
\code{\link{bifactorIndices}}, \code{\link{bifactorIndicesMplus}}
}
