% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mombivgeo.R
\name{mombivgeo}
\alias{mombivgeo}
\title{Moments Estimator for the Basu-Dhar Bivariate Geometric Distribution}
\source{
\code{\link[BivGeo]{mombivgeo}} is calculated directly from the definition.
}
\usage{
mombivgeo(x, y)
}
\arguments{
\item{x}{matrix or vector containing the data. If x is a matrix then it is considered as x the first column and y the second column (y argument need be setted to NULL). Additional columns and y are ignored.}

\item{y}{vector containing the data of y. It is used only if x is also a vector. Vectors x and y should be of equal length.}
}
\value{
\code{\link[BivGeo]{mombivgeo}} gives the values of the moments estimator.

Invalid arguments will return an error message.
}
\description{
This function computes the estimators based on the method of the moments for each parameter of the Basu-Dhar bivariate geometric distribution.
}
\details{
The moments estimators of \eqn{\theta_1, \theta_2, \theta_3} of the Basu-Dhar bivariate geometric distribution are given by:
\deqn{\hat \theta_1 = \frac{\bar{Y}(1 - \bar{W})}{\bar{W}(1 - \bar{Y})}}
\deqn{\hat \theta_2 = \frac{\bar{X}(\bar{W} - 1)}{\bar{W}(\bar{X} - 1)}}
\deqn{\hat \theta_3 = \frac{\bar{X}(\bar{X} - 1)(\bar{Y} - 1)}{(\bar{W} - 1)\bar{X} \bar{Y}}}
}
\examples{

# Generate the data set:

set.seed(123)
x1 		<- 	rbivgeo1(n = 1000, theta = c(0.5, 0.5, 0.7))
set.seed(123)
x2 		<- 	rbivgeo2(n = 1000, theta = c(0.5, 0.5, 0.7))

# Compute de moment estimator by:

mombivgeo(x = x1, y = NULL) # For data set x1
#             [,1]
# theta1 0.5053127
# theta2 0.5151873
# theta3 0.6640406

mombivgeo(x = x2, y = NULL) # For data set x2
#             [,1]
# theta1 0.4922327
# theta2 0.5001577
# theta3 0.6993893
}
\references{
Basu, A. P., & Dhar, S. K. (1995). Bivariate geometric distribution. \emph{Journal of Applied Statistical Science}, \bold{2}, 1, 33-44.

Li, J., & Dhar, S. K. (2013). Modeling with bivariate geometric distributions. \emph{Communications in Statistics-Theory and Methods}, 42, \bold{2}, 252-266.

Achcar, J. A., Davarzani, N., & Souza, R. M. (2016). Basu–Dhar bivariate geometric distribution in the presence of covariates and censored data: a Bayesian approach. \emph{Journal of Applied Statistics}, \bold{43}, 9, 1636-1648.

de Oliveira, R. P., & Achcar, J. A. (2018). Basu-Dhar's bivariate geometric distribution in presence of censored data and covariates: some computational aspects. \emph{Electronic Journal of Applied Statistical Analysis}, \bold{11}, 1, 108-136.
}
\seealso{
\code{\link[stats]{Geometric}} for the univariate geometric distribution.
}
\author{
Ricardo P. Oliveira \email{rpuziol.oliveira@gmail.com}

Jorge Alberto Achcar \email{achcar@fmrp.usp.br}
}
