% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blanket_statsments.R
\name{build_cox_model}
\alias{build_cox_model}
\title{Build a cox model}
\usage{
build_cox_model(
  df,
  event_time,
  event_censor,
  predictors,
  covariates = c(),
  verbose = FALSE
)
}
\arguments{
\item{df}{data.frame containing the data set}

\item{event_time}{character denoting column with event time}

\item{event_censor}{character denoting column specifying events/censoring}

\item{predictors}{character vector denoting columns with independent variables of interest}

\item{covariates}{character vector denoting columns with independent variables not of interest.
Covariates are mathematically identical to predictors but will be ignored in reporting}

\item{verbose}{logical. TRUE activates printout messages}
}
\value{
A Cox proportional hazards model
}
\description{
Build a Cox proportional hazards model from data and meta-parameters
}
\examples{
data <- survival::lung
mod <- build_cox_model(data, 'time', 'status', c('age', 'sex'))

}
\author{
J. Peter Marquardt
}
