// Copyright 2018 Google LLC. All Rights Reserved.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

// This file was automatically generated by the program contained in the source
// file write_poisson_mixture_tables.cpp.
#include <vector>
#include "LinAlg/Vector.hpp"
#include "Models/Glm/PosteriorSamplers/NormalMixtureApproximation.hpp"

namespace BOOM {
  void fill_poisson_mixture_approximation_table_3(
      NormalMixtureApproximationTable *table) {
    //----------------------------------------------------------------------
    // nu = 500 kl = 1.373e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.22395, -6.20187}),
                                      BOOM::Vector({0.0421075, 0.0447526}),
                                      BOOM::Vector({0.531677, 0.468323}));
      table->add(500, spec);
    }

    //----------------------------------------------------------------------
    // nu = 520 kl = 1.29645e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.26306, -6.24178}),
                                      BOOM::Vector({0.04129, 0.0439121}),
                                      BOOM::Vector({0.520907, 0.479093}));
      table->add(520, spec);
    }

    //----------------------------------------------------------------------
    // nu = 540 kl = 1.24835e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.30086, -6.28062}),
                                      BOOM::Vector({0.0404681, 0.0431561}),
                                      BOOM::Vector({0.495313, 0.504687}));
      table->add(540, spec);
    }

    //----------------------------------------------------------------------
    // nu = 560 kl = 1.17295e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.33698, -6.31715}),
                                      BOOM::Vector({0.0397802, 0.0423671}),
                                      BOOM::Vector({0.498725, 0.501275}));
      table->add(560, spec);
    }

    //----------------------------------------------------------------------
    // nu = 580 kl = 1.1091e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.37185, -6.35252}),
                                      BOOM::Vector({0.0391204, 0.0416371}),
                                      BOOM::Vector({0.498899, 0.501101}));
      table->add(580, spec);
    }

    //----------------------------------------------------------------------
    // nu = 600 kl = 1.04639e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.40558, -6.38654}),
                                      BOOM::Vector({0.0384929, 0.0409119}),
                                      BOOM::Vector({0.501935, 0.498065}));
      table->add(600, spec);
    }

    //----------------------------------------------------------------------
    // nu = 620 kl = 9.80833e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.43806, -6.41912}),
                                      BOOM::Vector({0.0379327, 0.0402053}),
                                      BOOM::Vector({0.517026, 0.482974}));
      table->add(620, spec);
    }

    //----------------------------------------------------------------------
    // nu = 640 kl = 9.34847e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.46969, -6.45122}),
                                      BOOM::Vector({0.0373464, 0.0395798}),
                                      BOOM::Vector({0.51269, 0.48731}));
      table->add(640, spec);
    }

    //----------------------------------------------------------------------
    // nu = 660 kl = 8.94393e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.50037, -6.48238}),
                                      BOOM::Vector({0.0367802, 0.0389877}),
                                      BOOM::Vector({0.506134, 0.493866}));
      table->add(660, spec);
    }

    //----------------------------------------------------------------------
    // nu = 680 kl = 3.04645e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.52791, -6.5144}),
                                      BOOM::Vector({0.0364536, 0.0391218}),
                                      BOOM::Vector({0.51484, 0.48516}));
      table->add(680, spec);
    }

    //----------------------------------------------------------------------
    // nu = 700 kl = 8.22981e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.55902, -6.5419}),
                                      BOOM::Vector({0.0357231, 0.0378771}),
                                      BOOM::Vector({0.494489, 0.505511}));
      table->add(700, spec);
    }

    //----------------------------------------------------------------------
    // nu = 720 kl = 7.82696e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.58702, -6.57013}),
                                      BOOM::Vector({0.035254, 0.0373351}),
                                      BOOM::Vector({0.499094, 0.500906}));
      table->add(720, spec);
    }

    //----------------------------------------------------------------------
    // nu = 740 kl = 7.50745e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.61431, -6.59775}),
                                      BOOM::Vector({0.0347861, 0.0368301}),
                                      BOOM::Vector({0.496696, 0.503304}));
      table->add(740, spec);
    }

    //----------------------------------------------------------------------
    // nu = 760 kl = 7.19123e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.64082, -6.62459}),
                                      BOOM::Vector({0.0343469, 0.0363482}),
                                      BOOM::Vector({0.497332, 0.502668}));
      table->add(760, spec);
    }

    //----------------------------------------------------------------------
    // nu = 780 kl = 6.87336e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.66668, -6.65062}),
                                      BOOM::Vector({0.0339231, 0.0358606}),
                                      BOOM::Vector({0.50021, 0.49979}));
      table->add(780, spec);
    }

    //----------------------------------------------------------------------
    // nu = 800 kl = 6.66614e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.69192, -6.67634}),
                                      BOOM::Vector({0.0334941, 0.0354398}),
                                      BOOM::Vector({0.4907, 0.5093}));
      table->add(800, spec);
    }

    //----------------------------------------------------------------------
    // nu = 820 kl = 9.045e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.7156, -6.70139}),
                                      BOOM::Vector({0.0332324, 0.0352054}),
                                      BOOM::Vector({0.513995, 0.486005}));
      table->add(820, spec);
    }

    //----------------------------------------------------------------------
    // nu = 840 kl = 6.09666e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.74045, -6.72513}),
                                      BOOM::Vector({0.032734, 0.03455}),
                                      BOOM::Vector({0.500846, 0.499154}));
      table->add(840, spec);
    }

    //----------------------------------------------------------------------
    // nu = 860 kl = 5.84318e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.76384, -6.74867}),
                                      BOOM::Vector({0.0323759, 0.0341331}),
                                      BOOM::Vector({0.506354, 0.493646}));
      table->add(860, spec);
    }

    //----------------------------------------------------------------------
    // nu = 880 kl = 5.62687e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.78673, -6.77176}),
                                      BOOM::Vector({0.0320202, 0.0337387}),
                                      BOOM::Vector({0.507327, 0.492673}));
      table->add(880, spec);
    }

    //----------------------------------------------------------------------
    // nu = 900 kl = 6.05797e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.80873, -6.79469}),
                                      BOOM::Vector({0.0317209, 0.0334817}),
                                      BOOM::Vector({0.509224, 0.490776}));
      table->add(900, spec);
    }

    //----------------------------------------------------------------------
    // nu = 920 kl = 5.26857e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.83105, -6.8166}),
                                      BOOM::Vector({0.0313256, 0.0330067}),
                                      BOOM::Vector({0.500185, 0.499815}));
      table->add(920, spec);
    }

    //----------------------------------------------------------------------
    // nu = 940 kl = 5.07604e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.85245, -6.83816}),
                                      BOOM::Vector({0.0310083, 0.0326478}),
                                      BOOM::Vector({0.503213, 0.496787}));
      table->add(940, spec);
    }

    //----------------------------------------------------------------------
    // nu = 960 kl = 4.93079e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.87345, -6.85944}),
                                      BOOM::Vector({0.0306838, 0.0323153}),
                                      BOOM::Vector({0.497591, 0.502409}));
      table->add(960, spec);
    }

    //----------------------------------------------------------------------
    // nu = 980 kl = 4.76264e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.89395, -6.88014}),
                                      BOOM::Vector({0.030387, 0.0319852}),
                                      BOOM::Vector({0.499898, 0.500102}));
      table->add(980, spec);
    }

    //----------------------------------------------------------------------
    // nu = 1000 kl = 6.37448e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.91158, -6.90291}),
                                      BOOM::Vector({0.0303611, 0.0323528}),
                                      BOOM::Vector({0.49953, 0.50047}));
      table->add(1000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 1000 kl = 6.37448e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-6.91158, -6.90291}),
                                      BOOM::Vector({0.0303611, 0.0323528}),
                                      BOOM::Vector({0.49953, 0.50047}));
      table->add(1000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 1100 kl = 4.38951e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.00958, -6.99601}),
                                      BOOM::Vector({0.0286797, 0.0300366}),
                                      BOOM::Vector({0.485908, 0.514092}));
      table->add(1100, spec);
    }

    //----------------------------------------------------------------------
    // nu = 1200 kl = -2.98307e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.09566, -7.08365}),
                                      BOOM::Vector({0.0275799, 0.028945}),
                                      BOOM::Vector({0.502866, 0.497134}));
      table->add(1200, spec);
    }

    //----------------------------------------------------------------------
    // nu = 1300 kl = 3.00556e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.17549, -7.16387}),
                                      BOOM::Vector({0.0265065, 0.0277429}),
                                      BOOM::Vector({0.504778, 0.495222}));
      table->add(1300, spec);
    }

    //----------------------------------------------------------------------
    // nu = 1400 kl = 2.68715e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.24937, -7.23845}),
                                      BOOM::Vector({0.0255622, 0.0267503}),
                                      BOOM::Vector({0.496393, 0.503607}));
      table->add(1400, spec);
    }

    //----------------------------------------------------------------------
    // nu = 1500 kl = 2.40919e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.31816, -7.30774}),
                                      BOOM::Vector({0.0247158, 0.0258436}),
                                      BOOM::Vector({0.493696, 0.506304}));
      table->add(1500, spec);
    }

    //----------------------------------------------------------------------
    // nu = 1600 kl = 4.49946e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.38186, -7.3732}),
                                      BOOM::Vector({0.0239913, 0.0252241}),
                                      BOOM::Vector({0.490665, 0.509335}));
      table->add(1600, spec);
    }

    //----------------------------------------------------------------------
    // nu = 1700 kl = 2.22298e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.44273, -7.43358}),
                                      BOOM::Vector({0.0232866, 0.0243353}),
                                      BOOM::Vector({0.492752, 0.507248}));
      table->add(1700, spec);
    }

    //----------------------------------------------------------------------
    // nu = 1800 kl = 2.29095e-05
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.4958, -7.49475}),
                                      BOOM::Vector({0.0235603, 0.0235661}),
                                      BOOM::Vector({0.500054, 0.499946}));
      table->add(1800, spec);
    }

    //----------------------------------------------------------------------
    // nu = 1900 kl = 1.84947e-05
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.54975, -7.5489}),
                                      BOOM::Vector({0.0229405, 0.022955}),
                                      BOOM::Vector({0.49739, 0.50261}));
      table->add(1900, spec);
    }

    //----------------------------------------------------------------------
    // nu = 2000 kl = -1.48623e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.60466, -7.59671}),
                                      BOOM::Vector({0.0216368, 0.0223742}),
                                      BOOM::Vector({0.496301, 0.503699}));
      table->add(2000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 2100 kl = 9.03009e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.65186, -7.647}),
                                      BOOM::Vector({0.0215999, 0.0218457}),
                                      BOOM::Vector({0.500024, 0.499976}));
      table->add(2100, spec);
    }

    //----------------------------------------------------------------------
    // nu = 2200 kl = 1.40788e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.69992, -7.692}),
                                      BOOM::Vector({0.0205393, 0.0213606}),
                                      BOOM::Vector({0.502706, 0.497294}));
      table->add(2200, spec);
    }

    //----------------------------------------------------------------------
    // nu = 2300 kl = 2.63889e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.7439, -7.737}),
                                      BOOM::Vector({0.0201173, 0.0210058}),
                                      BOOM::Vector({0.49963, 0.50037}));
      table->add(2300, spec);
    }

    //----------------------------------------------------------------------
    // nu = 2400 kl = 2.58714e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.78637, -7.77977}),
                                      BOOM::Vector({0.0197046, 0.020567}),
                                      BOOM::Vector({0.492288, 0.507712}));
      table->add(2400, spec);
    }

    //----------------------------------------------------------------------
    // nu = 2500 kl = 2.42504e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.82713, -7.82059}),
                                      BOOM::Vector({0.0193291, 0.0201269}),
                                      BOOM::Vector({0.497527, 0.502473}));
      table->add(2500, spec);
    }

    //----------------------------------------------------------------------
    // nu = 2600 kl = 3.40022e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.86607, -7.86017}),
                                      BOOM::Vector({0.018953, 0.0198058}),
                                      BOOM::Vector({0.492419, 0.507581}));
      table->add(2600, spec);
    }

    //----------------------------------------------------------------------
    // nu = 2700 kl = 4.66367e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.9036, -7.89801}),
                                      BOOM::Vector({0.0186046, 0.0194754}),
                                      BOOM::Vector({0.502581, 0.497419}));
      table->add(2700, spec);
    }

    //----------------------------------------------------------------------
    // nu = 2800 kl = -4.6475e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.94049, -7.93387}),
                                      BOOM::Vector({0.0182905, 0.0189237}),
                                      BOOM::Vector({0.50248, 0.49752}));
      table->add(2800, spec);
    }

    //----------------------------------------------------------------------
    // nu = 2900 kl = -6.1525e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-7.97582, -7.96881}),
                                      BOOM::Vector({0.0179553, 0.0185148}),
                                      BOOM::Vector({0.497591, 0.502409}));
      table->add(2900, spec);
    }

    //----------------------------------------------------------------------
    // nu = 3000 kl = 3.95781e-08
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.00954, -8.00282}),
                                      BOOM::Vector({0.0176444, 0.018249}),
                                      BOOM::Vector({0.502882, 0.497118}));
      table->add(3000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 3100 kl = -3.70327e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.04173, -8.03624}),
                                      BOOM::Vector({0.0174237, 0.0180838}),
                                      BOOM::Vector({0.505248, 0.494752}));
      table->add(3100, spec);
    }

    //----------------------------------------------------------------------
    // nu = 3200 kl = 1.20271e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.06784, -8.07358}),
                                      BOOM::Vector({0.0177684, 0.0171273}),
                                      BOOM::Vector({0.493156, 0.506844}));
      table->add(3200, spec);
    }

    //----------------------------------------------------------------------
    // nu = 3300 kl = -2.10646e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.10434, -8.09872}),
                                      BOOM::Vector({0.0168714, 0.0174847}),
                                      BOOM::Vector({0.499028, 0.500972}));
      table->add(3300, spec);
    }

    //----------------------------------------------------------------------
    // nu = 3400 kl = -9.15171e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.12918, -8.13364}),
                                      BOOM::Vector({0.017361, 0.0166367}),
                                      BOOM::Vector({0.504813, 0.495187}));
      table->add(3400, spec);
    }

    //----------------------------------------------------------------------
    // nu = 3500 kl = -8.49618e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.16278, -8.15796}),
                                      BOOM::Vector({0.0164078, 0.0170519}),
                                      BOOM::Vector({0.502927, 0.497073}));
      table->add(3500, spec);
    }

    //----------------------------------------------------------------------
    // nu = 3600 kl = 1.55678e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.19115, -8.18599}),
                                      BOOM::Vector({0.0161901, 0.0167409}),
                                      BOOM::Vector({0.497003, 0.502997}));
      table->add(3600, spec);
    }

    //----------------------------------------------------------------------
    // nu = 3700 kl = -1.36968e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.2133, -8.21859}),
                                      BOOM::Vector({0.0165011, 0.0159572}),
                                      BOOM::Vector({0.498181, 0.501819}));
      table->add(3700, spec);
    }

    //----------------------------------------------------------------------
    // nu = 3800 kl = -2.94869e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.23983, -8.24543}),
                                      BOOM::Vector({0.0162286, 0.0157245}),
                                      BOOM::Vector({0.501021, 0.498979}));
      table->add(3800, spec);
    }

    //----------------------------------------------------------------------
    // nu = 3900 kl = -2.08729e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.27133, -8.26588}),
                                      BOOM::Vector({0.0155421, 0.0160187}),
                                      BOOM::Vector({0.500275, 0.499725}));
      table->add(3900, spec);
    }

    //----------------------------------------------------------------------
    // nu = 4000 kl = -3.0894e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.29095, -8.29692}),
                                      BOOM::Vector({0.0157488, 0.0152972}),
                                      BOOM::Vector({0.501837, 0.498163}));
      table->add(4000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 4100 kl = -2.70018e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.32106, -8.31621}),
                                      BOOM::Vector({0.0151841, 0.015675}),
                                      BOOM::Vector({0.497563, 0.502437}));
      table->add(4100, spec);
    }

    //----------------------------------------------------------------------
    // nu = 4200 kl = -4.73742e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.34487, -8.34059}),
                                      BOOM::Vector({0.0150256, 0.0155468}),
                                      BOOM::Vector({0.497967, 0.502033}));
      table->add(4200, spec);
    }

    //----------------------------------------------------------------------
    // nu = 4300 kl = -2.02097e-05
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.3641, -8.36848}),
                                      BOOM::Vector({0.0153636, 0.0148063}),
                                      BOOM::Vector({0.508127, 0.491873}));
      table->add(4300, spec);
    }

    //----------------------------------------------------------------------
    // nu = 4400 kl = -3.90052e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.38672, -8.39181}),
                                      BOOM::Vector({0.0150691, 0.0146429}),
                                      BOOM::Vector({0.503772, 0.496228}));
      table->add(4400, spec);
    }

    //----------------------------------------------------------------------
    // nu = 4500 kl = -4.97761e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.41396, -8.40947}),
                                      BOOM::Vector({0.0144884, 0.0149855}),
                                      BOOM::Vector({0.500974, 0.499026}));
      table->add(4500, spec);
    }

    //----------------------------------------------------------------------
    // nu = 4600 kl = -2.52655e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.43582, -8.43159}),
                                      BOOM::Vector({0.0143533, 0.01483}),
                                      BOOM::Vector({0.500461, 0.499539}));
      table->add(4600, spec);
    }

    //----------------------------------------------------------------------
    // nu = 4700 kl = -4.31917e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.45722, -8.45318}),
                                      BOOM::Vector({0.0142004, 0.0146929}),
                                      BOOM::Vector({0.502414, 0.497586}));
      table->add(4700, spec);
    }

    //----------------------------------------------------------------------
    // nu = 4800 kl = 1.31966e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.47829, -8.47424}),
                                      BOOM::Vector({0.0140429, 0.0145374}),
                                      BOOM::Vector({0.500195, 0.499805}));
      table->add(4800, spec);
    }

    //----------------------------------------------------------------------
    // nu = 4900 kl = -1.47655e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.49891, -8.49485}),
                                      BOOM::Vector({0.0139047, 0.0143817}),
                                      BOOM::Vector({0.501637, 0.498363}));
      table->add(4900, spec);
    }

    //----------------------------------------------------------------------
    // nu = 5000 kl = -1.53395e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.51896, -8.51523}),
                                      BOOM::Vector({0.0137897, 0.0142476}),
                                      BOOM::Vector({0.500297, 0.499703}));
      table->add(5000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 5000 kl = -1.53395e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.51896, -8.51523}),
                                      BOOM::Vector({0.0137897, 0.0142476}),
                                      BOOM::Vector({0.500297, 0.499703}));
      table->add(5000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 6000 kl = 1.48672e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.69763, -8.70123}),
                                      BOOM::Vector({0.0129683, 0.0125986}),
                                      BOOM::Vector({0.500577, 0.499423}));
      table->add(6000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 7000 kl = 2.84904e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.85354, -8.85365}),
                                      BOOM::Vector({0.0119496, 0.0119505}),
                                      BOOM::Vector({0.498533, 0.501467}));
      table->add(7000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 8000 kl = 9.98068e-08
    {
      NormalMixtureApproximation spec(BOOM::Vector({-8.98579, -8.98846}),
                                      BOOM::Vector({0.0112703, 0.0109305}),
                                      BOOM::Vector({0.497781, 0.502219}));
      table->add(8000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 9000 kl = 9.26309e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-9.10494, -9.10491}),
                                      BOOM::Vector({0.0105425, 0.0105411}),
                                      BOOM::Vector({0.498561, 0.501439}));
      table->add(9000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 10000 kl = 8.33346e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-9.21027, -9.21031}),
                                      BOOM::Vector({0.0100003, 0.0100002}),
                                      BOOM::Vector({0.498815, 0.501185}));
      table->add(10000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 11000 kl = 1.59262e-07
    {
      NormalMixtureApproximation spec(BOOM::Vector({-9.30464, -9.30657}),
                                      BOOM::Vector({0.00962305, 0.00934794}),
                                      BOOM::Vector({0.500679, 0.499321}));
      table->add(11000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 12000 kl = 6.94572e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-9.39268, -9.39256}),
                                      BOOM::Vector({0.00912878, 0.00912846}),
                                      BOOM::Vector({0.498836, 0.501164}));
      table->add(12000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 13000 kl = 1.52334e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-9.47337, -9.47196}),
                                      BOOM::Vector({0.00866039, 0.00882835}),
                                      BOOM::Vector({0.50203, 0.49797}));
      table->add(13000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 14000 kl = 5.58565e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-9.54679, -9.54676}),
                                      BOOM::Vector({0.00844679, 0.00845911}),
                                      BOOM::Vector({0.500005, 0.499995}));
      table->add(14000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 15000 kl = 5.55839e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-9.61577, -9.61577}),
                                      BOOM::Vector({0.00816465, 0.0081647}),
                                      BOOM::Vector({0.498958, 0.501042}));
      table->add(15000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 16000 kl = 5.21058e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-9.68031, -9.68031}),
                                      BOOM::Vector({0.00790545, 0.00790545}),
                                      BOOM::Vector({0.498994, 0.501006}));
      table->add(16000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 17000 kl = 4.90194e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-9.74097, -9.74091}),
                                      BOOM::Vector({0.00766956, 0.00766968}),
                                      BOOM::Vector({0.499988, 0.500012}));
      table->add(17000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 18000 kl = 4.62991e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-9.7981, -9.7981}),
                                      BOOM::Vector({0.00745421, 0.00745315}),
                                      BOOM::Vector({0.500963, 0.499037}));
      table->add(18000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 19000 kl = 4.38616e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-9.85217, -9.85217}),
                                      BOOM::Vector({0.00725442, 0.00725536}),
                                      BOOM::Vector({0.499061, 0.500939}));
      table->add(19000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 20000 kl = 4.16666e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-9.90347, -9.90346}),
                                      BOOM::Vector({0.00707092, 0.00707148}),
                                      BOOM::Vector({0.500915, 0.499085}));
      table->add(20000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 21000 kl = 3.96844e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-9.95225, -9.95226}),
                                      BOOM::Vector({0.00690059, 0.006901}),
                                      BOOM::Vector({0.499107, 0.500893}));
      table->add(21000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 22000 kl = 3.78822e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-9.99877, -9.99878}),
                                      BOOM::Vector({0.00674238, 0.00674201}),
                                      BOOM::Vector({0.499128, 0.500872}));
      table->add(22000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 23000 kl = 3.62376e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-10.0432, -10.0432}),
                                      BOOM::Vector({0.00659379, 0.00659425}),
                                      BOOM::Vector({0.499148, 0.500852}));
      table->add(23000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 24000 kl = 3.47333e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-10.0858, -10.0858}),
                                      BOOM::Vector({0.00645478, 0.00645487}),
                                      BOOM::Vector({0.500832, 0.499168}));
      table->add(24000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 25000 kl = 3.33331e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-10.1266, -10.1266}),
                                      BOOM::Vector({0.00632456, 0.0063246}),
                                      BOOM::Vector({0.499993, 0.500007}));
      table->add(25000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 26000 kl = 3.45412e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-10.1658, -10.1659}),
                                      BOOM::Vector({0.00621372, 0.00619627}),
                                      BOOM::Vector({0.499801, 0.500199}));
      table->add(26000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 27000 kl = 3.08647e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-10.2036, -10.2036}),
                                      BOOM::Vector({0.00608584, 0.00608583}),
                                      BOOM::Vector({0.499992, 0.500008}));
      table->add(27000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 28000 kl = 2.97688e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-10.2399, -10.2399}),
                                      BOOM::Vector({0.00597614, 0.00597653}),
                                      BOOM::Vector({0.499221, 0.500779}));
      table->add(28000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 29000 kl = 2.89308e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-10.275, -10.275}),
                                      BOOM::Vector({0.00587124, 0.00587163}),
                                      BOOM::Vector({0.499153, 0.500847}));
      table->add(29000, spec);
    }

    //----------------------------------------------------------------------
    // nu = 30000 kl = 2.77959e-06
    {
      NormalMixtureApproximation spec(BOOM::Vector({-10.3089, -10.3089}),
                                      BOOM::Vector({0.00577355, 0.00577403}),
                                      BOOM::Vector({0.499231, 0.500769}));
      table->add(30000, spec);
    }
  }
}  // namespace BOOM
