% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sinesp_vde_data.R
\name{get_sinesp_vde_data}
\alias{get_sinesp_vde_data}
\title{get_sinesp_vde_data Function}
\usage{
get_sinesp_vde_data(
  state = "all",
  city = "all",
  year = "all",
  category = "all",
  typology = "all",
  granularity = "month"
)
}
\arguments{
\item{state}{State to be filtered. Character.}

\item{city}{City to be filtered. Character.}

\item{year}{Year of the crime. Integer.}

\item{category}{Crime category. Character.}

\item{typology}{Crime typology. For example: Furto de veículo, Roubo de carga. Character.}

\item{granularity}{Level of temporal granularity. Can be "year" or "month". Character.}
}
\value{
A data frame with the filtered data.
}
\description{
This function is responsible for collecting criminal data directly from the SINESP VDE database.
The data collected by this function starts temporally in January 2015 and goes until December 2022 for each brazilian city,
covering crimes such as: Estupro (Rape), Furto de veículo (Vehicle Theft), Homicídio doloso (Intentional Homicide),
Lesão corporal seguida de morte (Bodily Injury Followed by Death), Roubo a instituição financeira (Robbery of Financial Institution),
Roubo de carga (Cargo Theft), Roubo de veículo (Vehicle Robbery), Roubo seguido de morte (Latrocínio) (Robbery Followed by Death)
and Tentativa de homicídio (Attempted Homicide).
}
\examples{
\donttest{
dados <- get_sinesp_vde_data()
}

}
