% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsForest.R
\name{predict.forest}
\alias{predict.forest}
\title{Predict method for forest objects}
\usage{
\method{predict}{forest}(object, newdata, ...)
}
\arguments{
\item{object}{An object of class forest}

\item{newdata}{A data frame containing data for which to make predictions.}

\item{...}{Additional arguments}
}
\value{
produces a vector of predicted class labels
}
\description{
A function to make predictions for observations in a dataset based on a forest object.
}
\details{
This function returns predicted class labels for each observation, obtained by predicting the classification label for an observation based on each tree in the forest,
and subsequently taking a majority vote.
}
\examples{
require(MASS)
require(rpart)
#Function to draw a bootstrap sample from a dataset.
DrawBoots <- function(dataset, i){
set.seed(2394 + i)
Boot <- dataset[sample(1:nrow(dataset), size = nrow(dataset), replace = TRUE),]
return(Boot)
}

#Function to grow a tree using rpart on a dataset.
GrowTree <- function(x,y,BootsSample, minsplit = 40, minbucket = 20, maxdepth =3){
 controlrpart <- rpart.control(minsplit = minsplit, minbucket = minbucket,
 maxdepth = maxdepth, maxsurrogate = 0, maxcompete = 0)
 tree <- rpart(as.formula(paste(noquote(paste(y, "~")), noquote(paste(x, collapse="+")))),
 data = BootsSample, control = controlrpart)
 return(tree)
}

#Use functions to draw 20 boostrapsamples and grow a tree on each sample.
Boots<- lapply(1:20, function(k) DrawBoots(Pima.tr ,k))
Trees <- lapply(1:20, function (i) GrowTree(x=c("npreg", "glu",  "bp",  "skin",
"bmi", "ped", "age"),y="type", Boots[[i]] ))


#Turn the lists of dataframes and rpart trees to a forest object
myforest<- forest(Pima.tr,Boots,Trees)
myforest$partytrees

#Predict labels for observations in test set Pima.te, based on the forest
predict(myforest, Pima.te)
}
