% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CBPSMain.R
\name{CBPS.fit}
\alias{CBPS.fit}
\title{CBPS.fit determines the proper routine (what kind of treatment) and calls the 
approporiate function.  It also pre- and post-processes the data}
\usage{
CBPS.fit(treat, X, baselineX, diffX, ATT, method, iterations, standardize,
  twostep, sample.weights = sample.weights, ...)
}
\arguments{
\item{treat}{A vector of treatment assignments.  Binary or multi-valued
treatments should be factors.  Continuous treatments should be numeric.}

\item{X}{A covariate matrix.}

\item{baselineX}{Similar to \code{baseline.formula}, but in matrix form.}

\item{diffX}{Similar to \code{diff.formula}, but in matrix form.}

\item{ATT}{Default is 1, which finds the average treatment effect on the
treated interpreting the second level of the treatment factor as the
treatment.  Set to 2 to find the ATT interpreting the first level of the
treatment factor as the treatment.  Set to 0 to find the average treatment
effect. For non-binary treatments, only the ATE is available.}

\item{method}{Choose "over" to fit an over-identified model that combines
the propensity score and covariate balancing conditions; choose "exact" to
fit a model that only contains the covariate balancing conditions.}

\item{iterations}{An optional parameter for the maximum number of iterations
for the optimization.  Default is 1000.}

\item{standardize}{Default is \code{TRUE}, which normalizes weights to sum
to 1 within each treatment group.  For continuous treatments, normalizes
weights to sum up to 1 for the entire sample.  Set to \code{FALSE} to return
Horvitz-Thompson weights.}

\item{twostep}{Default is \code{TRUE} for a two-step estimator, which will
run substantially faster than continuous-updating.  Set to \code{FALSE} to
use the continuous-updating estimator described by Imai and Ratkovic (2014).}

\item{sample.weights}{Survey sampling weights for the observations, if
applicable.  When left NULL, defaults to a sampling weight of 1 for each
observation.}

\item{...}{Other parameters to be passed through to \code{optim()}.}
}
\value{
CBPS.fit object
}
\description{
CBPS.fit determines the proper routine (what kind of treatment) and calls the 
approporiate function.  It also pre- and post-processes the data
}
