% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDFtestingSuite.R
\name{CDFtest}
\alias{CDFtest}
\title{Comprehensively evaluate and visualize the utility of 
    CDF-generating implementations.}
\usage{
CDFtest(Visualization = TRUE, OutputDirectory = 0, functlist, Fnameslist,
  epslist = c(0.05, 0.1, 1), datalist, Dnameslist, synthsets = NULL, range,
  gran = 1, granlist = c(1), samplesize = 0, nlist = (10000),
  cdfstep = 1, reps = 5, ExtraTests_CDF = list(),
  ExtraTests_PDF = list(), setseed = -100, comments = "none",
  SmoothAll = FALSE, EmpiricBounds = FALSE, AnalyticBounds = FALSE,
  AnalyticProbSleeve = FALSE, SuppressRealCDF = FALSE,
  SuppressDPCDF = FALSE, SuppressLegends = FALSE, ...)
}
\arguments{
\item{Visualization}{Sets the testing suite into Visualization mode (default, 
      \code{Visualization = TRUE}) 
   or Data Collection mode \code{(Visualization = FALSE)}
In Visualization mode (default):
  A \code{.csv} file conatining the mean and median results (across \code{reps}
      iterations) of diagnostic functions on DP-CDF algorithms per each 
      combination of data, function, and epsilon. 
  A \code{.pdf} file containing one graphical example DP CDF for each combination
      of dataset, function, and epsilon, as well as a set of boxplots 
      showing the distribution of all diagnostic results for all 
      combinations of parameters.
In Data Collection mode (set \code{Visualization = FALSE}):
  A \code{.csv} file containing the entire (raw) results (across \code{reps}
  iterations) of diagnostic functions on DP-CDF algorithms
  per each combination of dataset, and function, seperately looped over
  all epsilons, then all granularities, and all samplesizes.}

\item{OutputDirectory}{The location of the folder which will hold the
output (\code{.csv} and \code{.pdf} files). This defaults to the
\code{tempdir()} directory.}

\item{functlist}{A list of CDF-computing functions to be tested on the
\code{CDFtestTrack} (if \code{visualization = TRUE}) or \code{CDFtestTrackx}
(if \code{Visualization =FALSE}))}

\item{Fnameslist}{A vector of function names corresponding to the functions}

\item{epslist}{A vector of epsilon values for differential privacy}

\item{datalist}{A list containing vectors of data, each to be used in a test}

\item{Dnameslist}{A list of dataset names corresponding to the data/variables 
being tested; used for labelling the output}

\item{synthsets}{This script generates pre-defined synthetic datasets upon 
request, and fully incorporates them into testing. To call them, users
should input a string vector containing the names of the sets they desire.
  For example, \code{synthsets = list(list(type,size,shape),list(type,size,shape))}.
  There are no limits on the amounts of datasets included.
  Sets available include:
     type:  \code{"age"} (which ranges from about 0 to 100, \code{gran =1})
     and \code{"wage"} which ranges from 0 to 500k);
     size:  Any positive integer. Type in exact numerical representation
       (eg, for ten thousand use 10000 not 10k and not 10^4);
     shape: gaussian, sparse, uniform, bimodal;
     It is assumed that the data input is rounded to the granularity}

\item{range}{The range of the domain as a vector \code{c(min, max)}. Defined based 
on user intuition. to preserve differential privacy, the domain is constructed
using this range. Setting the min too high will bias output upward. 
Same in reverse for a low max. However, setting min too low and max 
too high could reveal the true limits of your data,
compromising some privacy.}

\item{gran}{FOR Visualization MODE ONLY. refer to \code{granlist} for setting 
granularities (thus domain sizes) in Data Collection mode.
This command is irrelevant in Data Collection mode.          
The granularity of the domain between the min and max. ie, if age is
measureds per 1 year of age, \code{gran =1}.
The same granularity is applied to all datasets, so using comparable 
(or scaled) data is necessary.}

\item{granlist}{FOR Data Collection MODE ONLY. refer to \code{gran} for selecting
samplesizes in Data Collection mode. This command is irrelevant in
Visualization mode. A list of granularities of the domain between the
min and max. ie, if age is measure per 1 year of age, \code{gran =1}.}

\item{samplesize}{FOR Visualization MODE ONLY. refer to \code{nlist} for selecting
samplesizes in Data Collection mode. This command is irrelevant in 
Data Collection mode. when set to zero, the entire dataset is used.
Otherwise, the specified sample size is randomly selected from each dataset
without replacement.}

\item{nlist}{FOR Data Collection MODE ONLY. refer to \code{samplesize} for 
selecting samplesizes in visualization mode. This command is irrelevant in
Visualization mode. Sets the absolute sample sizes to draw from each
dataset, with replacement. Any vector of integer values is appropriate.}

\item{cdfstep}{The step size used in outputting the approximate CDF;}

\item{reps}{The number of times to repeat each diagnostic. higher \code{reps} lends
greater accuracy, but comsumes time and power. Author recommends \code{reps = 10}
for quick examples and \code{reps = 100} for more robust examinations.}

\item{ExtraTests_CDF}{If a user wishes to add extra diagnostics, the proper
 \code{ExtraTests_CDF = list(functionName1=function1, functionName2=function2)}.  
Diagnostic Functions should have inputs such as \code{Y} for a public CDF,
 \code{est} for a DP-representation of that CDF,
 \code{range} and \code{gran}, and the output should be just one value.}

\item{ExtraTests_PDF}{See above}

\item{setseed}{In the function, each combination of data, epsilon, and
function is executed with a separate seed, which by default is randomly
generated and reported. Users interested in replicating specific results
can locate the reported seed and parameter combination to replicate tests.}

\item{comments}{"Comments written here print to a log in excel"}

\item{SmoothAll}{Applies L2 monotnocity post-processing to every DP-CDF}

\item{EmpiricBounds}{FOR Visualization MODE ONLY. When TRUE, outputted graphs
depict the minimum and maximum values taken by each bin across reps}

\item{AnalyticBounds}{FOR Visualization MODE ONLY. This is a flag and should
 be set to \code{TRUE} if the functions being tested are expected to output 
analytical variance bounds. The proper output form for such a function is 
 \code{output = list(DPCDFvector, LowerBoundVector, UpperBoundVector)}.}

\item{AnalyticProbSleeve}{FOR Visualization MODE ONLY. When \code{TRUE}, outputted
DP-CDFs will have a 'fuzzy' analytic sleeve around them, approximating
probabalitity density for each point given by DP. This also requires the
function format specified above in the description for \code{AnalyticBounds}.}

\item{SuppressRealCDF}{FOR Visualization MODE ONLY. When \code{TRUE}, outputted
graphs will not include real (non-private) CDFs.}

\item{SuppressDPCDF}{FOR Visualization MODE ONLY. When \code{TRUE}, outputted
graphs will not include DP-CDFs (but if \code{SmoothAll = TRUE}, monotonized
DP CDFs still appear).}

\item{SuppressLegends}{FOR Visualization MODE ONLY. When \code{TRUE}, outputted
graphs will not include legends}

\item{...}{Optionally add additional parameters. This is primarily used to allow automated
execution of varied diagnostic functions.}
}
\value{
If \code{Visualization = TRUE}, a list containing:                        

 ...\code{$means} Contains mean diagnostic
 results for each diagnostic across reps iterations for each parameter combination;
 
..\code{$medians} Contains median diagnostic 
 results for each diagnostic across reps iterations for each parameter combination;\\

...\code{$yourCDFoutput} Containing a single dpCDF iteration for each parameter combination;\\

...\code{$yourPDFoutput}  Containing a single dpPDF iteration for each parameter combination;\\

...\code{$realCDFoutput} Containing the real (non-DP) CDF output for each relevant parameter combination;

...\code{$realPDFoutput} Containing the real (non-DP) PDF output for each relevant parameter combination;

...\code{$databins} Containing the domain used to construct the CDFs;

...\code{$TestPack_CDF} Containing the definitions of diagnostic functions used on dpCDFs;

...\code{$TestPack_PDF} Containing the definitions of diagnostic functions used on dpPDFs;

...\code{$allscores} Containing all raw diagnostic output.

...\code{$seed} Containing the list of seeds used in the test

...\code{$permetric} holding a rearranged dataframe (ordered by parameter
                  combinations) useful for plotting.
 
 A \code{.pdf} file:
     with boxplots showing the distributions of diagnostic outputs, 
     and categorized plots of dp-CDF function output. Each such graph with
     show one arbitrary CDF iterations and empirical boundaries.
     the empirical boundaries are the max and min values reached by that
     function (and parameters) during the test.
             
  A \code{.csv} file:
     containing the mean and median scores of each diagnostic on each 
     combination of data, eps, function, and the seedlist for reproduction.

 Notes on Visualization mode: Both the \code{.pdf} and \code{.csv} components are named with a time stamp index,
 in the form of \code{YearMonthDayHourMinuteSecond}. To locate particular tests,
 look at the \code{CDFtestindexchart.csv}, which automatically records the
 parameters and index of each test. These can be found in the file specified by 
 \code{OutputDirectory}, which defaults to the R temp files \code{tempdir()}.
 
 Alternatively in Data Collection mode (\code{Visualization = FALSE}), a list containing:

     ...\code{$allscores} holding the output of each combination of parameters,
     which is that each \code{eps} in epslist is varied across the first value
     specified in \code{granlist} and \code{nlist}. The same is true for varying
     granularity and sample size. In that way, only one variable is varied at a time
     while the other two are held fixed. All such combinations of parameters are
     executed on all combinations of data and function (specified within       
     ...\code{datalist} and \code{functlist});
     
     ...\code{$seed} holding the list of seeds used in the test.
     
   A \code{.csv} file conatining the entire (raw) results (across reps iterations) 
   of diagnostic functions on DP-CDF algorithms per each combination of 
   dataset, and function, looped over epsilon, granularity, and sample size values
   as described directly above.\\
   This mode was designed for collecting metric data for subsequent supervised 
   learning modelling.
}
\description{
The suite is a system for determining the utility
    of differentially private cumulative distribution function (DP-CDF)
    algorithm implementations. The system can empirically evaluate and 
    provide visualizations for several DP-CDF algorithms simultaneously,
    under various parameters. It can also be set to focus strictly on data
    collection, rather than spending time on visualization. 
    
    It comes with several pre-loaded adjustable synthetic datasets, and can
    also analyze functions on user-defined datasets.
    
    dpCDF implementations to test must take the following as arguments:
    \code{data, epsilon, granularity, range}, and any number of other inputs.
    Use "?functionH" for an example of an implementation drawing on C++ files
     through Rcpp.
    
      USERS SHOULD NOTE: the
    following included diagnostic functions are under development:
    \code{SkewDiffpdf,KurtDiffpdf, StdDiffpdf}, corresponding to error measurements of
    skewness, kurtoses, and standard deviations generated from dpCDFs.
    This is evident through the occasional result of \code{NA}.
}
\examples{
CDFtest( Visualization = TRUE,OutputDirectory = 0, functlist = c(functionH),
Fnameslist = c("H"), epslist  = c(.1, .01), datalist = list(),
Dnameslist = c(), synthsets= list(list("wage", 100000, "uniform"), 
 list("wage",100000,"sparse"), list("wage",100000,"bimodal")),
 range    = c(1,500000),gran =1000,granlist =c(2500,1250,1000,500), 
 samplesize = 0,nlist = c(100,1000,10000,100000,1000000),
 cdfstep  =0, reps = 5,  ExtraTests_CDF = list(),ExtraTests_PDF = list(),
 setseed = c(-100),
 comments = "x",SmoothAll = FALSE,EmpiricBounds = FALSE,
 AnalyticBounds = FALSE,AnalyticProbSleeve = FALSE,
 SuppressRealCDF = FALSE,SuppressDPCDF = FALSE,SuppressLegends = FALSE)
}

