% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionFramework.R
\name{functionS2}
\alias{functionS2}
\title{Build dpCDFs through Histogram smoothing and minimized expected L2 per bin}
\usage{
functionS2(eps, cdfstep, data, range, gran, K = 16, ...)
}
\arguments{
\item{eps}{Epsilon value for Differential privacy control}

\item{cdfstep}{The step sized used in outputting the approximate CDF; 
the values output are [min, min + cdfstep], [min, min + 2 * cdfstep], etc.}

\item{data}{A vector of the data (single variable to compute CDFs from)}

\item{range}{A vector length 2 containing user-specified min and max to truncate the universe to}

\item{gran}{The smallest unit of measurement in the data (one [year] for a list of ages)}

\item{K}{This sets the degree of the underlying tree}

\item{...}{Optionally add additional parameters}
}
\value{
A list with 2 vectors: one is the y coordinates of the DP-CDF, the other is the
   abs values of the anlytically expected bounds for a similarly-constructed
   non-monotonized DP-CDF made without merging of bins, at 95 percent probability.
}
\description{
The function seperates the epsilon value in two.
The first epsilon component is used to privately discover
 the best way to merge contiguous histogram bins in order to reduce the L2 error 
 due to the noise addition. It then applies the discovered bin merging to the original histogram,
 and outputs it by utilizing epsilon2. 
 Finally, it utilizes this output to compute and release the private CDF.
}
\examples{
functionS2(eps = .01, cdfstep = .1, data = rexp(10000,.4), range= c(1,10), gran = .1, K= 2)
}

