% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDFtestingSuite.R
\name{horzdiffatMed}
\alias{horzdiffatMed}
\title{Determine the distance between the median values returned by two CDFs.}
\usage{
horzdiffatMed(Y, est, range, gran, ...)
}
\arguments{
\item{Y}{The vector output of a non-differentially private CDF
computation (cumulative count bins)}

\item{est}{The vector output of a differentially private CDF
computation (cumulative count bins)}

\item{range}{A vector length 2 containing user-specified min and max to
truncate the universe to}

\item{gran}{The smallest unit of measurement in the data (one [year] 
for a list of ages)}

\item{...}{Optionally add additional parameters. This is primarily used to allow automated
execution of varied diagnostic functions.}
}
\value{
The horizontal error at the median
}
\description{
Find the distance between the median value and that returned
   by the DP CDF.
}
\examples{
horzdiffatMed(c(.1,.2,.3,.4,.5,.6,.7,.8,.9,1), 
   c(.1,.2,.3,.3,.3,.3,.3,.3,.4,1),c(1,10), 1)
}

