% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdm.R
\name{snapshot}
\alias{snapshot}
\title{Extract CDM metadata}
\usage{
snapshot(cdm)
}
\arguments{
\item{cdm}{A cdm object}
}
\value{
A named list of attributes about the cdm including selected fields
from the cdm_source table and record counts from the person and
observation_period tables
}
\description{
Extract the name, version, and selected record counts from a cdm.
}
\examples{
\dontrun{
library(CDMConnector)
con <- DBI::dbConnect(duckdb::duckdb(), eunomia_dir())
cdm <- cdm_from_con(con, cdm_tables = c(tbl_group("default"), "cdm_source"))
snapshot(cdm)

DBI::dbDisconnect(con, shutdown = TRUE)
}
}
