% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/optimizer.R
\name{buildModel}
\alias{buildModel}
\title{Model building}
\usage{
buildModel(x, y, distanceFunction, control)
}
\arguments{
\item{x}{list of samples in input space}

\item{y}{matrix, column vector of observations for each sample}

\item{distanceFunction}{a suitable distance function of type f(x1,x2), returning a scalar distance value, preferably between 0 and 1.
Maximum distances larger 1 are no problem, but may yield scaling bias when different measures are compared.
   Should be non-negative and symmetric.  In case Kriging is chosen, it can also be a list of several distance functions. In this case, MLE is used
   to determine the most suited distance measure (see the last reference).}

\item{control}{list of options \cr
\code{model} Model to be used as a surrogate of the target function. Default is "K" (Kriging). Also
        available are: "LM" (linear, distance-based model), "RBFN" Radial Basis Function Network.\cr
\code{modelSettings} List of settings for model building, passed on as the control argument to the model training functions \code{\link{combinatorialKriging}}, \code{\link{combinatorialLM}}, \code{\link{combinatorialRBFN}}.
\code{infill} This parameter specifies a function to be used for the infill criterion (e.g., the default is expected improvement \code{infillExpectedImprovement}).
To use no specific infill criterion this has to be set to \code{NA}. Infill criteria are only used with models that may provide some error estimate with predictions.\cr}
}
\value{
a list:\cr
\code{fit} model-fit \cr
\code{fpred} prediction function
}
\description{
Model building support function for optimCEGO. Should not be called directly.
}
\seealso{
\code{\link{optimCEGO}}
}
\keyword{internal}

