% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/optimizer.R
\name{optimCEGO}
\alias{optimCEGO}
\title{Combinatorial Efficient Global Optimization}
\usage{
optimCEGO(par = NULL, fun, creationFunction, distanceFunction,
  control = list())
}
\arguments{
\item{par}{Optional initial design as a list. If NULL (default), creationFunction is used to create initial design.
If par has less individuals than specified by \code{control$evalInit}, creationFunction will fill up the design.}

\item{fun}{target function to be minimized}

\item{creationFunction}{Function to create individuals/solutions in search space}

\item{distanceFunction}{a suitable distance function of type f(x1,x2), returning a scalar distance value, preferably between 0 and 1.
Maximum distances larger 1 are no problem, but may yield scaling bias when different measures are compared.
   Should be non-negative and symmetric. With the setting \code{control$model="K"} this can also be a list of different fitness functions.}

\item{control}{(list), with the options of optimization and model building approaches employed\cr
\code{evalInit} Number of initial evaluations (i.e., size of the initial design), integer, default is \code{2}\cr
\code{vectorized} Boolean. Defines whether target function is vectorized (takes a list of solutions as argument) or not (takes single solution as argument). Default: FALSE\cr
\code{verbosity} Level of text output during run. Defaults to 0, no output.\cr
\code{plotting} Plot optimization progress during run (TRUE) or not (FALSE). Default is FALSE.\cr
\code{targetY} optimal value to be found, stopping criterion, default is \code{-Inf}\cr
\code{evalBudget} maximum number of target function evaluations, default is \code{100}\cr
\code{creationRetries} When a model does not predict an actually improving solution, a random exploration step is performed. \code{creationRetries} solutions are created randomly.
        For each, distance to all known solutions is calculated. The minimum distance is recorded for each random solution.
        The random solution with maximal minimum distance is chosen doe be evaluated in the next iteration.\cr
\code{model} Model to be used as a surrogate of the target function. Default is "K" (Kriging). Also
        available are: "LM" (linear, distance-based model), "RBFN" Radial Basis Function Network.\cr
\code{modelSettings} List of settings for model building, passed on as the control argument to the model training functions \code{\link{combinatorialKriging}}, \code{\link{combinatorialLM}}, \code{\link{combinatorialRBFN}}.
\code{infill} This parameter specifies a function to be used for the infill criterion (e.g., the default is expected improvement \code{infillExpectedImprovement}).
To use no specific infill criterion this has to be set to \code{NA}. Infill criteria are only used with models that may provide some error estimate with predictions.\cr
\code{optimizer} Optimizer that finds the minimum of the surrogate model. Default is \code{"EA"} an Evolutionary Algorithm. No alternatives implemented yet.
\code{optimSettings} List of settings for the method to optimize the model.}
}
\value{
a list:\cr
\code{xbest} best solution found\cr
\code{ybest} fitness of the best solution\cr
\code{x} history of all evaluated solutions\cr
\code{y} corresponding target function values f(x)\cr
\code{fit} model-fit created in the last iteration\cr
\code{fpred} prediction function created in the last iteration\cr
\code{count} number of performed target function evaluations
}
\description{
Model-based optimization for combinatorial or mixed problems. Based on measures of distance or dissimilarity.
}
\examples{
seed=0
glgseed=1
#distance
dF <- distancePermutationHamming
#mutation
mF <- mutationPermutationSwap
#recombination
rF <-  recombinationPermutationCycleCrossover
#creation
cF <- function()sample(5)
#objective function
lF <- landscapeGeneratorUNI(ref=1:5,distFun=dF)
#start optimization
set.seed(seed)
res1 <- optimCEGO(,lF,cF,dF,list(optimSettings=list(
				mutationFunction=mF,recombinationFunction=rF),
		evalInit=5,budget=15,targetY=0,verbosity=1,model="K"))
set.seed(seed)
res2 <- optimCEGO(,lF,cF,dF,list(optimSettings=list(
				mutationFunction=mF,recombinationFunction=rF),
		evalInit=5,budget=15,targetY=0,verbosity=1,model="RBFN"))
res1$xbest
res2$xbest
}
\references{
Zaefferer, Martin; Stork, Joerg; Friese, Martina; Fischbach, Andreas; Naujoks, Boris; Bartz-Beielstein, Thomas. (2014). Efficient global optimization for combinatorial problems. In Proceedings of the 2014 conference on Genetic and evolutionary computation (GECCO '14). ACM, New York, NY, USA, 871-878. DOI=10.1145/2576768.2598282 http://doi.acm.org/10.1145/2576768.2598282

Zaefferer, Martin; Stork, Joerg; Bartz-Beielstein, Thomas. (2014). Distance Measures for Permutations in Combinatorial Efficient Global Optimization. In Parallel Problem Solving from Nature - PPSN XIII (p. 373-383). Springer International Publishing.
}
\seealso{
\code{\link{combinatorialKriging}}, \code{\link{combinatorialLM}}, \code{\link{combinatorialRBFN}}, \code{\link{buildModel}}, \code{\link{optimEA}}
}

