% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim_CICA.R
\name{Sim_CICA}
\alias{Sim_CICA}
\title{Simulate CICA data}
\usage{
Sim_CICA(
  Nr,
  Q,
  R,
  voxels,
  timepoints,
  E,
  overlap = NULL,
  externalscore = FALSE
)
}
\arguments{
\item{Nr}{number of subjects per cluster}

\item{Q}{number of components}

\item{R}{number of clusters}

\item{voxels}{number of voxels}

\item{timepoints}{number of time points}

\item{E}{proportion of independent gaussian noise}

\item{overlap}{amount of overlap between S across clusters. Smaller value means more overlap}

\item{externalscore}{add simulated external score (default is FALSE)}
}
\value{
a list with simulated CICA data
}
\description{
Simulate CICA data
}
\examples{
\dontrun{

#Use set.seed(1) to obtain the dataset used in the article "Clusterwise
#Independent Component Analysis (CICA): an R package for clustering subjects
#based on ICA patterns underlying three-way (brain) data"

Xe <- Sim_CICA(Nr = 15, Q = 5, R = 4, voxels = 100, timepoints = 10,
E = 0.4, overlap = .25, externalscore = TRUE)
}

}
