% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_genodata.R
\name{generate_genodata}
\alias{generate_genodata}
\alias{generate_singleton_data}
\alias{generate_doubleton_data}
\title{Functions to generate genetic data.}
\usage{
generate_genodata(n_SNV = 100, n_ind = 1000)

generate_singleton_data(n_SNV = 100, n_ind = 1000)

generate_doubleton_data(n_SNV = 100, n_ind = 1000)
}
\arguments{
\item{n_SNV}{Integer specifying the number of SNVs that are generated.}

\item{n_ind}{Integer specifying the number of observations that are generated.}
}
\value{
A dataframe containing \code{n_ind} observations of \code{n_SNV} SNVs.
}
\description{
Functions to generate genetic data in the form of single
nucleotide variants (SNVs). The function
\code{\link{generate_singleton_data}} generates singletons (i.e. SNVs with
one observed minor allele); \code{\link{generate_doubleton_data}}
generates doubletons (i.e. SNVs with two observed minor alleles), and the
function \code{\link{generate_genodata}} generates \code{n_ind}
observations of \code{n_SNV} SNVs with random minor allele frequencies.
}
\examples{
genodata1 <- generate_singleton_data()
compute_MAF(genodata1)

genodata2 <- generate_doubleton_data()
compute_MAF(genodata2)

genodata3 <- generate_genodata()
compute_MAF(genodata3)

}
