% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_ehv_cables.R
\name{financial_cof_ehv_cables}
\alias{financial_cof_ehv_cables}
\title{Financial cost of Failure for EHV UG cables & 132 kV UG cables}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
financial_cof_ehv_cables(ehv_asset_category)
}
\arguments{
\item{ehv_asset_category}{String The type of EHV cable distribution asset category
Options: \code{ehv_asset_category =
c("33kV UG Cable (Oil)", "33kV UG Cable (Gas)", "33kV UG Cable (Non Pressurised)",
"66kV UG Cable (Oil)", "66kV UG Cable (Gas)", "66kV UG Cable (Non Pressurised)",
"132kV UG Cable (Oil)", "132kV UG Cable (Gas)", "132kV UG Cable (Non Pressurised)")}.}
}
\value{
Numeric. Financial consequences of failure for EHV switchgear
}
\description{
This function calculates financial consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Financial consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
financial_cof_ehv_cables(ehv_asset_category = "33kV UG Cable (Oil)")
}
