% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMBO_data_2stage.R
\name{COMBO_data_2stage}
\alias{COMBO_data_2stage}
\title{Generate Data to use in two-stage COMBO Functions}
\usage{
COMBO_data_2stage(
  sample_size,
  x_mu,
  x_sigma,
  z_shape,
  v_shape,
  beta,
  gamma,
  delta
)
}
\arguments{
\item{sample_size}{An integer specifying the sample size of the generated data set.}

\item{x_mu}{A numeric value specifying the mean of \code{x} predictors
generated from a Normal distribution.}

\item{x_sigma}{A positive numeric value specifying the standard deviation of
\code{x} predictors generated from a Normal distribution.}

\item{z_shape}{A positive numeric value specifying the shape parameter of
\code{z} predictors generated from a Gamma distribution.}

\item{v_shape}{A positive numeric value specifying the shape parameter of
\code{v} predictors generated from a Gamma distribution.}

\item{beta}{A column matrix of \eqn{\beta} parameter values (intercept, slope)
to generate data under in the true outcome mechanism.}

\item{gamma}{A numeric matrix of \eqn{\gamma} parameters
to generate data under in the first-stage observation mechanism.
In matrix form, the \code{gamma} matrix rows correspond to intercept (row 1)
and slope (row 2) terms. The gamma parameter matrix columns correspond to the true outcome categories
\eqn{Y \in \{1, 2\}}.}

\item{delta}{A numeric array of \eqn{\delta} parameters to generate data under
the second-stage observation mechanism. In array form, the \code{delta} matrix rows
correspond to intercept (row 1) and slope (row 2) terms. The matrix columns correspond
to first-stage observed outcome categories. The third dimension of the \code{delta}
array is indexed by the true outcome categories.}
}
\value{
\code{COMBO_data_2stage} returns a list of generated data elements:
\item{obs_Ystar}{A vector of first-stage observed outcomes.}
\item{obs_Ytilde}{A vector of second-stage observed outcomes.}
\item{true_Y}{A vector of true outcomes.}
\item{obs_Ystar_matrix}{A numeric matrix of indicator variables (0, 1) for the first-stage observed
outcome \code{Y*}. Rows of the matrix correspond to each subject. Columns of
the matrix correspond to each observed outcome category. Each row contains
exactly one 0 entry and exactly one 1 entry.}
\item{obs_Ytilde_matrix}{A numeric matrix of indicator variables (0, 1) for the second-stage observed
outcome \code{Y*}. Rows of the matrix correspond to each subject. Columns of
the matrix correspond to each observed outcome category. Each row contains
exactly one 0 entry and exactly one 1 entry.}
\item{x}{A vector of generated predictor values in the true outcome
mechanism, from the Normal distribution.}
\item{z}{A vector of generated predictor values in the first-stage observation
mechanism from the Gamma distribution.}
\item{v}{A vector of generated predictor values in the second-stage observation
mechanism from the Gamma distribution.}
\item{x_design_matrix}{The design matrix for the \code{x} predictor.}
\item{z_design_matrix}{The design matrix for the \code{z} predictor.}
\item{v_design_matrix}{The design matrix for the \code{v} predictor.}
}
\description{
Generate Data to use in two-stage COMBO Functions
}
\examples{
set.seed(123)
n <- 500
x_mu <- 0
x_sigma <- 1
z_shape <- 1
v_shape <- 1

true_beta <- matrix(c(1, -2), ncol = 1)
true_gamma <- matrix(c(.5, 1, -.5, -1), nrow = 2, byrow = FALSE)
true_delta <- array(c(1.5, 1, .5, .5, -.5, 0, -1, -1), dim = c(2, 2, 2))

my_data <- COMBO_data_2stage(sample_size = n,
                             x_mu = x_mu, x_sigma = x_sigma,
                             z_shape = z_shape, v_shape = v_shape,
                             beta = true_beta, gamma = true_gamma, delta = true_delta)
table(my_data[["obs_Ytilde"]], my_data[["obs_Ystar"]], my_data[["true_Y"]])
}
