% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{forest_cpbayes}
\alias{forest_cpbayes}
\title{Forest plot presenting pleiotropy result obtained by CPBayes.}
\usage{
forest_cpbayes(mcmc_output, level = 0.05)
}
\arguments{
\item{mcmc_output}{A list returned by either 
 \code{\link{cpbayes_uncor}} or \code{\link{cpbayes_cor}}. This list 
contains all the primary results and MCMC data produced by \code{\link{cpbayes_uncor}}
 or \code{\link{cpbayes_cor}}. No default is specified. See the example below.}

\item{level}{A numeric value. (1-level)\% confidence interval of the unknown true genetic effect (beta/log(odds ratio))
on each trait is plotted in the forest plot. Default choice is 0.05.}
}
\value{
The output produced by this function is a diagram file in .pdf format. The details of the diagram are as follows: 
   \item{file_name}{The pdf file is named after the genetic variant. So, if the argument `Variant'
   in \code{\link{cpbayes_uncor}} or \code{\link{cpbayes_cor}} is specified as 'rs1234', the figure file is named as rs1234.pdf.} 
   \item{Title}{At the top of the figure, variant name and the corresponding log10(Bayes factor) and PPNA produced by CPBayes is stated.}
   \item{Column1}{First column in the figure specifies the name of the phenotypes.}
   \item{Column2}{Second column provides the trait-specific univariate association p-values for each trait.}
   \item{Column3}{Third column provides the trait-specific posterior probability of association (PPAj) produced by CPBayes.}
   \item{Column4}{Fourth column states whether a phenotype was selected in the optimal subset of associated/non-null traits
   detected by CPBayes. If a phenotype was not selected, selected and positively associated, selected and negatively associated,
    its association status is stated as null, positive, and negative, respectively.}
   \item{Column5}{In the right section of the figure, the primary eatimate and confidence interval of the beta/log(odds ratio) parameter for
    each trait is plotted.}
}
\description{
Run the \code{\link{forest_cpbayes}} function to create a forest plot that presents the pleiotropy result obtained
by \code{\link{cpbayes_uncor}} or \code{\link{cpbayes_cor}}.
}
\examples{
data(ExampleDataUncor)
BetaHat <- ExampleDataUncor$BetaHat
SE <- ExampleDataUncor$SE
traitNames <- paste("Disease", 1:10, sep = "")
SNP1 <- "rs1234"
result <- cpbayes_uncor(BetaHat, SE, Phenotypes = traitNames, Variant = SNP1)
forest_cpbayes(result, level = 0.05) 

}
\references{
Arunabha Majumdar, Tanushree Haldar, Sourabh Bhattacharya, John Witte.
 An efficient Bayesian meta-analysis 
 approach for studying cross-phenotype genetic associations (submitted), available
 at: http://biorxiv.org/content/early/2017/01/18/101543.
}
\seealso{
\code{\link{cpbayes_uncor}}, \code{\link{cpbayes_cor}}, \code{\link{post_summaries}}, \code{\link{estimate_corln}}
}
