% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPGLIB_Coefficient_Functions.R
\name{coef.cv.CPGLIB}
\alias{coef.cv.CPGLIB}
\title{Coefficients for cv.CPGLIB Object}
\usage{
\method{coef}{cv.CPGLIB}(object, groups = NULL, ensemble_average = FALSE, ...)
}
\arguments{
\item{object}{An object of class cv.CPGLIB.}

\item{groups}{The groups in the ensemble for the coefficients. Default is all of the groups in the ensemble.}

\item{ensemble_average}{Option to return the average of the coefficients over all the groups in the ensemble. Default is FALSE.}

\item{...}{Additional arguments for compatibility.}
}
\value{
The coefficients for the cv.CPGLIB object. Default is FALSE.
}
\description{
\code{coef.cv.CPGLIB} returns the coefficients for a cv.CPGLIB object.
}
\examples{
\donttest{
# Data simulation
set.seed(1)
n <- 50
N <- 2000
p <- 300
beta.active <- c(abs(runif(p, 0, 1/2))*(-1)^rbinom(p, 1, 0.3))
# Parameters
p.active <- 150
beta <- c(beta.active[1:p.active], rep(0, p-p.active))
Sigma <- matrix(0, p, p)
Sigma[1:p.active, 1:p.active] <- 0.5
diag(Sigma) <- 1

# Train data
x.train <- mvnfast::rmvn(n, mu = rep(0, p), sigma = Sigma) 
prob.train <- exp(x.train \%*\% beta)/
              (1+exp(x.train \%*\% beta))
y.train <- rbinom(n, 1, prob.train)
# Test data
x.test <- mvnfast::rmvn(N, mu = rep(0, p), sigma = Sigma)
prob.test <- exp(x.test \%*\% beta)/
             (1+exp(x.test \%*\% beta))
y.test <- rbinom(N, 1, prob.test)
mean(y.test)

# CV CPGLIB - Multiple Groups
cpg.out <- cv.cpg(x.train, y.train,
                  glm_type = "Logistic",
                  G = 5, include_intercept = TRUE,
                  alpha_s = 3/4, alpha_d = 1,
                  n_lambda_sparsity = 100, n_lambda_diversity = 100,
                  tolerance = 1e-5, max_iter = 1e5)
cpg.coef <- coef(cpg.out)

# Coefficients for each group                
cpg.coef <- coef(cpg.out, ensemble_average = FALSE)

}


}
\seealso{
\code{\link{cv.cpg}}
}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
