% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_polar_plot.R
\name{ch_polar_plot}
\alias{ch_polar_plot}
\title{Polar plot of daily streamflows}
\usage{
ch_polar_plot(
  bmw,
  lcol1 = c("black", "gray50"),
  lcol2 = c("black", "gray50"),
  lfill = c("yellow", "green"),
  lsig = c("red", "blue")
)
}
\arguments{
\item{bmw}{output from \code{\link{ch_binned_MannWhitney}}}

\item{lcol1}{line colour, default is \code{c("black","gray50")}}

\item{lcol2}{point colour, default is \code{c("black","gray50")}}

\item{lfill}{fill colour, default is \code{c("yellow","green")}}

\item{lsig}{significance symbol colour, default is \code{c("red","blue")}}
}
\value{
No value is returned; a standard \R graphic is created.
}
\description{
Produces a polar plot similar to that used in \cite{Whitfield and Cannon, 2000}. It uses output 
from the function \code{\link{ch_binned_MannWhitney}} or a data structure created using 
the function \code{\link{ch_polar_plot_prep}}.
}
\examples{
range1 <- c(1970,1979)
range2 <- c(1990,1999)
b_MW <- ch_binned_MannWhitney(CAN05AA008, step = 5, range1, range2, 
ptest <- 0.05)
ch_polar_plot(b_MW)
}
\references{
Whitfield, P.H. and A.J. Cannon. 2000. Polar plotting of seasonal hydrologic
and climatic data. Northwest Science 74: 76-80.

Whitfield, P.H., Cannon, A.J., 2000. Recent variations in climate and hydrology
in Canada. Canadian Water Resources Journal 25: 19-65.
}
\seealso{
\code{\link{ch_binned_MannWhitney}} \code{\link{ch_polar_plot_prep}}
}
\author{
Paul Whitfield
}
\keyword{plot}
