% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Threshold.R
\name{CST_Threshold}
\alias{CST_Threshold}
\title{Absolute value of a relative threshold (percentile)}
\usage{
CST_Threshold(
  data,
  threshold,
  start = NULL,
  end = NULL,
  time_dim = "ftime",
  memb_dim = "member",
  sdate_dim = "sdate",
  na.rm = FALSE,
  ncores = NULL
)
}
\arguments{
\item{data}{An 's2dv_cube' object as provided function \code{CST_Load} in
package CSTools.}

\item{threshold}{A single scalar or vector indicating the relative 
threshold(s).}

\item{start}{An optional parameter to defined the initial date of the period 
to selectfrom the data by providing a list of two elements: the initial date
of the period and the initial month of the period. By default it is set to 
NULL and the indicator is computed using all the data provided in 
\code{data}.}

\item{end}{An optional parameter to defined the final date of the period to 
select from the data by providing a list of two elements: the final day of 
the period and the final month of the period. By default it is set to NULL 
and the indicator is computed using all the data provided in \code{data}.}

\item{time_dim}{A character string indicating the name of the temporal 
dimension. By default, it is set to 'ftime'. More than one dimension name 
matching the dimensions provided in the object \code{data$data} can be 
specified. This dimension is required to subset the data in a requested 
period.}

\item{memb_dim}{A character string indicating the name of the dimension in 
which the ensemble members are stored. When set it to NULL, threshold is 
computed for individual members.}

\item{sdate_dim}{A character string indicating the name of the dimension in 
which the initialization dates are stored.}

\item{na.rm}{A logical value indicating whether to ignore NA values (TRUE) or 
not (FALSE).}

\item{ncores}{An integer indicating the number of cores to use in parallel 
computation.}
}
\value{
An ’s2dv_cube’ object containing the corresponding values of a
percentile in the element \code{data}.
}
\description{
Frequently, thresholds are defined by a percentile that may correspond to a 
different absolute value depending on the variable, gridpoint and also julian 
day (time). This function calculates the corresponding value of a percentile 
given a dataset.
}
\examples{
threshold <- 0.9
exp <- NULL
exp$data <- array(rnorm(5 * 3 * 214 * 2),
                   c(member = 5, sdate = 3, ftime = 214, lon = 2)) 
exp$Dates$start <- c(seq(as.Date("01-05-2000", format = "\%d-\%m-\%Y"), 
                       as.Date("30-11-2000", format = "\%d-\%m-\%Y"), by = 'day'),
                   seq(as.Date("01-05-2001", format = "\%d-\%m-\%Y"), 
                       as.Date("30-11-2001", format = "\%d-\%m-\%Y"), by = 'day'),
                   seq(as.Date("01-05-2002", format = "\%d-\%m-\%Y"), 
                       as.Date("30-11-2002", format = "\%d-\%m-\%Y"), by = 'day'))
class(exp) <- 's2dv_cube'
exp_probs <- CST_Threshold(exp, threshold, start = list(21, 4), end = list(21, 6))

}
