% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{expression-parts}
\alias{expression-parts}
\alias{variables}
\alias{parameters}
\alias{constants}
\alias{atoms}
\title{Parts of an Expression Leaf}
\usage{
variables(object)

parameters(object)

constants(object)

atoms(object)
}
\arguments{
\item{object}{A \linkS4class{Leaf} object.}
}
\value{
A list of \linkS4class{Variable}, \linkS4class{Parameter}, \linkS4class{Constant}, or \linkS4class{Atom} objects.
}
\description{
List the variables, parameters, constants, or atoms in a canonical expression.
}
\examples{
set.seed(67)
m <- 50
n <- 10
beta <- Variable(n)
y <- matrix(rnorm(m), nrow = m)
X <- matrix(rnorm(m*n), nrow = m, ncol = n)
lambda <- Parameter()

expr <- sum_squares(y - X \%*\% beta) + lambda*p_norm(beta, 1)
variables(expr)
parameters(expr)
constants(expr)
lapply(constants(expr), function(c) { value(c) })
}
