% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{forecast}
\alias{forecast}
\title{Generates a forecast base on calibration run with \code{\link{calibrate}}}
\usage{
forecast(modelfit, x.new)
}
\arguments{
\item{modelfit}{a \code{\link{calibrate.class}} object}

\item{x.new}{newdata for the prediction}
}
\value{
return a \code{\link{model.class}} (see \code{\link{model.class}} for more details)
}
\description{
\code{forecast} is a function that allows to generate a new \code{\link{model.class}} in which the prediction is
done with the Maximum A Posteriori
}
\details{
Note that all the methods for a \code{\link{model.class}} object are availble. Be careful with the \code{x} in the
 plot function. It needs to be the x-axis of calibrated data and predicted data.
}
\examples{
\dontrun{
###################### The code to calibrate
X <- cbind(seq(0,1,length.out=10),seq(0,1,length.out=10))
code <- function(X,theta)
{
  return((6*X[,1]*theta[2]-2)^2*theta[1]*sin(theta[3]*X[,2]-4))
}
Yexp <- code(X,c(1,1,11))+rnorm(10,0,0.1)

############### For the first model
###### Definition of the model
md <- model(code,X,Yexp,"model1")
###### Definition of the prior densities
pr <- prior(type.prior=c("gaussian","gaussian","gaussian","gamma"),opt.prior=
list(c(1,0.01),c(1,0.01),c(11,3),c(2,0.1)))
###### Definition of the calibration options
opt.estim=list(Ngibbs=200,Nmh=600,thetaInit=c(1,1,11,0.1),r=c(0.3,0.3),
sig=diag(4),Nchains=1,burnIn=100)
###### Run the calibration
mdfit <- calibrate(md,pr,opt.estim)
###### Prediction between 1 and 1.2
X.new <- cbind(seq(1,1.2,length.out=10),seq(1,1.2,length.out=10))
fr <- forecast(mdfit,X.new)
print(fr)
plot(fr,c(X[,1],X.new[,1]))
}
}
\seealso{
\code{\link{model}}, \code{\link{prior}}, \code{\link{calibrate}}, \code{\link{sequentialDesign}}
}
\author{
M. Carmassi
}
