% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dag.R
\name{translate_dagitty}
\alias{translate_dagitty}
\title{Puts your DAG into 'dagitty' syntax (useful for using their plotting functions)}
\usage{
translate_dagitty(model)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by \code{\link{make_model}}.}
}
\value{
A \code{\link[dagitty]{dagitty}} translation of \code{DAG}
}
\description{
If confounds are indicated (provided in \code{attr(model$P, 'confounds')}), then these are represented as bidirectional arcs.
}
\examples{
\dontrun{
model <- make_model('X -> Y')
CausalQueries:::translate_dagitty(model)
}

}
\keyword{internal}
