% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSpectra.R
\name{plotSpectra}
\alias{plotSpectra}
\title{Plot Spectra Object}
\usage{
plotSpectra(
  spectra,
  which = c(1),
  yrange = range(spectra$data),
  offset = 0,
  amplify = 1,
  lab.pos = mean(spectra$freq),
  showGrid = TRUE,
  leg.loc = "none",
  ...
)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link[=Spectra]{Spectra()}}.}

\item{which}{An integer vector specifying which spectra to plot, and the
order.}

\item{yrange}{A vector giving the limits of the y axis desired, for instance
\code{c(0, 15)}.  This parameter depends upon the range of values in the
stored spectra and defaults to the height of the largest peak in the data
set.  Interacts with the next two arguments, as well as the number of
spectra to be plotted as given in \code{which}.  Trial and error is used to
adjust all these arguments to produce the desired plot.}

\item{offset}{A number specifying the vertical offset between spectra if
more than one is plotted.  Set to 0.0 to overlay the spectra.}

\item{amplify}{A number specifying an amplification factor to be applied to
all spectra.  Useful for magnifying spectra so small features show up
(though large peaks will then be clipped, unless you zoom on the x axis).}

\item{lab.pos}{A number (in frequency units) giving the location of a label for each spectrum.
Generally, pick an area that is clear in all spectra plotted.  If no label
is desired, set \code{lab.pos = "none"}.}

\item{showGrid}{Logical.  Places light gray vertical lines at each tick mark
if \code{TRUE}.}

\item{leg.loc}{Either a list with elements \code{x} and \code{y}, or a string like \code{'topright'}.  Values in a list should be on \verb{[0,1]}, i.e. the lower left of the plot area is \verb{0,0} and the upper right is \verb{1,1}.  Allowed string values are those described in \code{\link[graphics:legend]{graphics::legend()}} under 'Details'. A value of \code{'none'} is acceptable as well.}

\item{\dots}{Parameters to be passed to the plotting routines. \emph{Applies to base graphics only}.}
}
\value{
The returned value depends on the graphics option selected (see \code{\link[=GraphicsOptions]{GraphicsOptions()}}).
\itemize{
\item \code{base}: None.  Side effect is a plot.
\item \code{ggplot2}: The plot is displayed, and a \code{ggplot2} object is returned if the value is assigned.  The plot can be modified in the usual \code{ggplot2} manner.
}
}
\description{
Plots the spectra stored in a \code{\link{Spectra}} object. Spectra may be plotted
offset or stacked.  The vertical scale is controlled by a combination of
several parameters.
}
\examples{
# This example assumes the graphics output is set to ggplot2 (see ?GraphicsOptions).
library("ggplot2")
data(metMUD1)

p1 <- plotSpectra(metMUD1, which = c(10, 11), yrange = c(0, 1.5),
  offset = 0.06, amplify = 10, lab.pos = 0.5)
p1 <- p1 + ggtitle("metMUD1 NMR Data")
p1

# Add a legend at x, y coords
p2 <- plotSpectra(metMUD1, which = c(10, 11), yrange = c(0, 1.5),
  offset = 0.06, amplify = 10, lab.pos = 0.5, leg.loc = list(x = 0.8, y = 0.8))
p2 <- p2 + ggtitle("metMUD1 NMR Data")
p2

}
\seealso{
\code{\link{plotSpectraJS}} for the interactive version. See \code{\link{GraphicsOptions}}
for more information about the graphics options. Additional documentation at
\url{https://bryanhanson.github.io/ChemoSpec/}
}
\author{
Bryan A. Hanson (DePauw University), Tejasvi Gupta.
}
\keyword{hplot}
