% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_mrca.R
\name{find_mrca}
\alias{find_mrca}
\title{Find ancestor}
\usage{
find_mrca(descendant_names, tree)
}
\arguments{
\item{descendant_names}{A vector of mode character representing the tip names for which an ancestor is sought.}

\item{tree}{The tree as a phylo object.}
}
\value{
\item{ancestor_node}{The ancestral node number.}
}
\description{
Finds the last common ancestor (node) of a set of two or more descendant tips.
}
\details{
Intended for use as an internal function for \link{trim_matrix}, but potentially of more general use.
}
\examples{

# Create a simple four-taxon tree:
tree <- ape::read.tree(text = "(A,(B,(C,D)));")

# Plot the tree:
ape::plot.phylo(tree)

# Add nodelabels and show that the most recent common
# ancestor of B, C, and D is node 6:
ape::nodelabels()

# Use find_mrca to show that the most recent common
# ancestor of B, C, and D is node 6:
find_mrca(
  descendant_names = c("B", "C", "D"),
  tree = tree
)
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
