% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.cladisticMatrix.r
\name{print.cladisticMatrix}
\alias{print.cladisticMatrix}
\title{Compact display of a cladistic matrix}
\usage{
\method{print}{cladisticMatrix}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"cladisticMatrix"}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Nothing is directly returned, instead a text summary describing the dimensions and nature of an object of class \code{"cladisticMatrix"} is printed to the console.
}
\description{
Displays a compact summary of the dimensions and nature of a cladistic matrix object.
}
\details{
Displays some basic summary information on a cladistic matrix object, including number and type of characters, information about ordering, and whether variable weights are used.
}
\examples{

# Show print.cladisticMatrix version of each included data sets:
print.cladisticMatrix(x = day_2016)
print.cladisticMatrix(x = gauthier_1986)
print.cladisticMatrix(x = michaux_1989)

}
\seealso{
\link{build_cladistic_matrix}, \link{compactify_matrix}, \link{prune_cladistic_matrix}, \link{read_nexus_matrix}, \link{safe_taxonomic_reduction}, \link{write_nexus_matrix}, \link{write_tnt_matrix}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
