% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShiftLon.R
\name{ShiftLon}
\alias{ShiftLon}
\title{Shift longitudes of a data array}
\usage{
ShiftLon(data, lon, westB, lon_dim = "lon", ncores = NULL)
}
\arguments{
\item{data}{A named multidimensional array with at least 'lon_dim' dimension.}

\item{lon}{A numeric vector of longitudes. The values are expected to be 
monotonic increasing.}

\item{westB}{A number indicating the west boundary of the new longitudes.}

\item{lon_dim}{A character string indicating the name of the longitude 
dimension in 'data'. The default value is 'lon'.}

\item{ncores}{An integer indicating the number of cores used for computation.
The default value is NULL (use only one core).}
}
\value{
A list of 2:
\item{data}{
 Array of the shifted data with the same dimensions as parameter 'data'.
}
\item{lon}{
 The monotonic increasing new longitudes with the same length as parameter 
 'lon' and start at 'westB'.
}
}
\description{
Shift the longitudes of a data array. Only reasonable for global
 longitude shifting. It is useful for map plotting or aligning datasets.
}
\examples{
data <- array(data = 1:50, dim = c(lon = 360, lat = 181))
lon <- array(data = 0:359, dim = c(lon = 360))
lat <- -90:90 ## lat does not change
shifted <- ShiftLon(data = data, lon = lon, westB = -180, ncores = 1)

 \dontrun{
s2dv::PlotEquiMap(var = data, lon = lon, lat = lat, filled.continents = FALSE)
s2dv::PlotEquiMap(var = shifted$data, lon = shifted$lon, lat = lat, filled.continents = FALSE)
 }
 
}
