% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde.torus.R
\name{kde.torus}
\alias{kde.torus}
\title{Kernel density estimation using circular von Mises distribution}
\usage{
kde.torus(data, eval.point = grid.torus(), concentration = 25)
}
\arguments{
\item{data}{n x 2 matrix of toroidal data on \eqn{[0, 2\pi)^2}}

\item{eval.point}{N x N numeric matrix on \eqn{[0, 2\pi)^2}. Default input is
\code{grid.torus}.}

\item{concentration}{positive number which has the role of \eqn{\kappa} of
von Mises distribution. Default value is 25.}
}
\value{
\code{kde.torus} returns N-dimensional vector of kdes evaluated at eval.point
}
\description{
\code{kde.torus} returns a kde using independent bivariate von mises kernel.
}
\examples{
data <- ILE[1:200, 1:2]

kde.torus(data)
}
\references{
S. Jung, K. Park, and B. Kim (2021),
  "Clustering on the torus by conformal prediction"
}
\seealso{
\code{\link{grid.torus}}
}
