\name{makeCurrent}
\alias{makeCurrent}
\alias{makeBase}

\title{ Move the pointer named CURRENT (BASE) in the CoCo object }

\description{
   Move the internal pointer named CURRENT (BASE)
   in the list of models in the CoCo object.
   Values returned from models are by default of the CURRENT model.
   By default, the CURRENT model is tested against the BASE model.
}

\usage{
makeCurrent(model = "last", silent = TRUE, both = FALSE, push = FALSE,
	   data = NULL, object = .object.of.model(model, 
                                                  data = data, ...), ...)
makeBase(model = "current", silent = TRUE, both = FALSE, push = FALSE,
	 data = NULL, object = .object.of.model(model, 
                                                data = data, ...), ...)
}

\arguments{
  \item{model}{ Numeric, text string, or model object.
	 If numeric then the CURRENT (BASE) pointer is moved to 
	 the model with that number (if the model is available).
	 The model number is then returned. 
         The text strings \code{"base"}, \code{"current"}, \code{"last"},
         \code{"previous"}, and \code{"next"} will
	 cause the model pointer to be moved to respectively the BASE model,
	 the CURRENT model, the LAST model (model the largest number),
	 the model with the largest number smaller
         then the number of the CURRENT (BASE) model, and finally
	 the model with the smallest number larger
         then the number of the CURRENT (BASE) model.
	 }
  \item{silent}{ Logical: If FALSE then some error messages are printed
		 when the model is not available. }
  \item{both}{ Logical: 
               If \code{both} is TRUE then both pointers 
	       (CURRENT and BASE) are moved (in CoCoCg):
               For \code{"next"} and \code{"previous"} first the CURRENT (BASE) model
	       of the call is set, and then the other pointer BASE (CURRENT)
	       are moved to the same model. }
  \item{push}{ Logical: 
               If \code{push} is TRUE then both pointers are pushed onto
	       a stack internally in the CoCoCg object - with the ability
	       to restore the pointers by, e.g., the \code{pop} argument to
               \code{\link{returnModelNumber}}. }
  \item{data}{ ( See \code{\link{exportCoCo}}. ) }
  \item{object}{ See \code{\link{exportCoCo}}. }
  \item{\dots}{ ( Additional arguments to generate the CoCo \code{object}
	 from the \code{data} argument. See \code{\link{propertyModel}}. ) }
}

\details{
 The model first entered into a CoCo object is
 both BASE and CURRENT, and is given the number 1.
 The BASE (first) model stays BASE until another model is declared as BASE.
 Additional entered models, models created by \code{\link{editModel}}
 and models selected in steps of \code{\link{backward}}
 and \code{\link{forward}} are given an increasing number,
 and inserted into the model list.
 The model last entered is the CURRENT model.
 The last model generated by \code{\link{editModel}} or
 selected in steps of \code{\link{backward}} or \code{\link{forward}}
 is the LAST model, and can be named CURRENT by 
 \code{makeCurrent(model = "last", ...)}.
}

\value{
  The logical FALSE is returned, if the model is not available,
  else an integer is returned. If the model argument is an integer or
  a model object then the model number is returned.
}

\references{Badsberg, J.H.: A guide to CoCo, JSS, 2001
            ( http://www.jstatsoft.org/v06/i04/ )
            and Badsberg, J.H.: Xlisp+CoCo, Aalborg University, 1996. }

\author{Jens Henrik Badsberg}

\note{ \code{both} and \code{push} is only implemented for CoCoCg objects. 

\code{makeCurrent(model = "previous", ...)} 
at the first model will return FALSE,
but \code{makeCurrent(model = "next", ...)} at the last model 
will set the CURRENT to the first model in the model list, 
and return an integer.

\code{makeCurrent} will not accept a text string with the generating class
of a model as an argument.
(\code{makeCurrent} without a CoCo object is irrelevant. )

}

\seealso{\code{\link{enterModel}}, \code{\link{showModel}},
         \code{\link{returnTest}},
         \code{\link{isSubmodel}}, \code{\link{propertyModel}}, 
         \code{\link{returnModel}} and \code{\link{returnModelNumber}}. }

\examples{
library(CoCo);
data(Reinis);
CoCoObject <- makeCoCo();
enterTable(Reinis, object = CoCoObject);

# Enter the saturated model:	
enterModel("*", object = CoCoObject);

# Generate some models, here by "backward":
backward(recursive = TRUE, headlong = TRUE, coherent = TRUE, 
         follow = TRUE, object = CoCoObject);

# Show the model list:
showModel("all", object = CoCoObject);

# Test the last model against the saturated model (the first model):
makeCurrent("last", object = CoCoObject);
showTest(object = CoCoObject);

# "last" is default for makeCurrent:
showModel("all", object = CoCoObject);
makeCurrent(object = CoCoObject);
showModel("all", object = CoCoObject);

# "current" is default for makeBase:
makeBase(object = CoCoObject);
showModel("all", object = CoCoObject);
makeBase("current", object = CoCoObject);
showModel("all", object = CoCoObject);

# Generate some more models, here by "editModel":
	
enterModel("ADEF,ABDG.;", object = CoCoObject);
makeBase(object = CoCoObject);

editModel(action = "drop.interactions", modification = "ABDG.;",
          object = CoCoObject);
makeCurrent("last", object = CoCoObject);
showTest(object = CoCoObject);

editModel(action = "drop.edges", modification = "AD,BG.;",
          object = CoCoObject);
makeCurrent("last", object = CoCoObject);
showTest(object = CoCoObject);

enterModel("ADF,AEF,BD,G.;", object = CoCoObject);
makeCurrent("last", object = CoCoObject);
showTest(object = CoCoObject);

enterModel(".;", object = CoCoObject);

showModel("all", object = CoCoObject);

makeBase(2, object = CoCoObject);
makeCurrent(6, object = CoCoObject);

showModel("all", object = CoCoObject);
	
# Show the first 10 models:
makeCurrent(10, object = CoCoObject)
while(makeCurrent("previous", 
                  object = CoCoObject)) showModel(object = CoCoObject)

# Show the first 10 models:
makeCurrent(10, object = CoCoObject)
while(returnModelNumber("current", object = CoCoObject) < 15) {
	 makeCurrent("next", object = CoCoObject); 
	 showModel(object = CoCoObject); }

endCoCo(object = CoCoObject);
}
\keyword{ methods }% at least one, from doc/KEYWORDS
\keyword{ multivariate }% __ONLY ONE__ keyword per line
