% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateCohortExplorerApp.R
\name{createCohortExplorerApp}
\alias{createCohortExplorerApp}
\title{Create Cohort explorer shiny app with person level data}
\usage{
createCohortExplorerApp(
  connectionDetails = NULL,
  connection = NULL,
  cohortDatabaseSchema = NULL,
  cdmDatabaseSchema,
  vocabularyDatabaseSchema = cdmDatabaseSchema,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  cohortTable = "cohort",
  cohortDefinitionId,
  cohortName = NULL,
  doNotExportCohortData = FALSE,
  sampleSize = 25,
  personIds = NULL,
  exportFolder,
  databaseId,
  shiftDates = FALSE,
  assignNewId = FALSE
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package. Can be left NULL if \code{connection} is
provided.}

\item{connection}{An object of type \code{connection} as created using the
\code{\link[DatabaseConnector]{connect}} function in the
DatabaseConnector package. Can be left NULL if \code{connectionDetails}
is provided, in which case a new connection will be opened at the start
of the function, and closed when the function finishes.}

\item{cohortDatabaseSchema}{Schema name where your cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{cdmDatabaseSchema}{Schema name where your OMOP CDM tables with person level data reside.
Note that for SQL Server, this should include both the database and schema name, for example
'scratch.dbo'.}

\item{vocabularyDatabaseSchema}{Schema name where your OMOP vocabulary tables reside. It maybe the cdmDatabaseSchema.
Note that for SQL Server, this should include both the database and schema name, for example
'scratch.dbo'.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support
temp tables. To emulate temp tables, provide a schema with write
privileges where temp tables can be created.}

\item{cohortTable}{The name of the cohort table.}

\item{cohortDefinitionId}{The cohort id to extract records.}

\item{cohortName}{(optional) Cohort Name}

\item{doNotExportCohortData}{(Optional) Do you want to not export cohort data? If set to true, parameters
cohortDefinitionId, cohort, cohortDatabaseSchema, cohortName will be ignored.
The persons entire observation period would be considered the cohort. Cohort
Name will be 'Observation Period', cohort id will be set to 0.}

\item{sampleSize}{(Optional, default = 20) The number of persons to randomly sample.
Ignored, if personId is given.}

\item{personIds}{(Optional) An array of personId's to look for in Cohort table and CDM.}

\item{exportFolder}{The folder where the output will be exported to. If this folder does
not exist it will be created.}

\item{databaseId}{A short string for identifying the database (e.g. 'Synpuf'). This will
be displayed in 'shiny' app to toggle between databases. Should not have
space or underscore (_).}

\item{shiftDates}{(Default = FALSE) Do you want to shift dates? This will help further
de-identify data. The shift is the process of re calibrating dates such
that all persons mi (observation_period_start_date) is 2000-01-01.}

\item{assignNewId}{(Default = FALSE) Do you want to assign a newId for persons. This will
replace the personId in the source with a randomly assigned newId.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{                      Returns invisibly the full path of the export folder where the
                               files were created. In this path are the files that are part of the 'shiny'
                               app.
}\if{html}{\out{</div>}}
}
\description{
Export person level data from OMOP CDM tables for eligible persons in the cohort. Creates a folder with files
that are part of the Cohort Explorer 'shiny' app. This app may then be run to review person level profiles.
}
\examples{
\dontrun{
connectionDetails <- createConnectionDetails(
  dbms = "postgresql",
  server = "ohdsi.com",
  port = 5432,
  user = "me",
  password = "secure"
)

createCohortExplorerApp(
  connectionDetails = connectionDetails,
  cohortDefinitionId = 1234
)
}

}
