% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{Linked_Dose_Formula}
\alias{Linked_Dose_Formula}
\title{Calculates Full Parameter list for Special Dose Formula}
\usage{
Linked_Dose_Formula(tforms, paras, verbose = FALSE)
}
\arguments{
\item{tforms}{list of formula types}

\item{paras}{list of formula parameters}

\item{verbose}{boolean to control if additional information is printed to the console, also accepts 0/1 integer}
}
\value{
returns list of full parameters
}
\description{
\code{Linked_Dose_Formula} Calculates all parameters for linear-quadratic and linear-exponential linked formulas
}
\examples{
library(data.table)
tforms <- list("cov_0"="quad", "cov_1"="exp")
paras <- list("cov_0"=c(1,3.45), "cov_1"=c(1.2, 4.5, 0.1))
full_paras <- Linked_Dose_Formula(tforms, paras)

}
