% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{gen_time_dep}
\alias{gen_time_dep}
\title{Applies time dependence to parameters}
\usage{
gen_time_dep(
  df,
  time1,
  time2,
  event0,
  iscox,
  dt,
  new_names,
  dep_cols,
  func_form,
  fname,
  tform,
  nthreads = as.numeric(detectCores())
)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{time1}{column used for time period starts}

\item{time2}{column used for time period end}

\item{event0}{column used for event status}

\item{iscox}{boolean if rows not at event times should not be kept, rows are removed if true. a Cox proportional hazards model does not use rows with intervals not containing event times}

\item{dt}{spacing in time for new rows}

\item{new_names}{list of new names to use instead of default, default used if entry is ''}

\item{dep_cols}{columns that are not needed in the new dataframe}

\item{func_form}{vector of functions to apply to each time-dependent covariate. Of the form func(df, time) returning a vector of the new column value}

\item{fname}{filename used for new dataframe}

\item{tform}{list of string function identifiers, used for linear/step}

\item{nthreads}{number of threads to use, do not use more threads than available on your machine}
}
\value{
returns the updated dataframe
}
\description{
\code{gen_time_dep} generates a new dataframe with time dependent covariates by applying a grid in time
}
\examples{
library(data.table)
# Adapted from the tests
a <- c(20, 20, 5, 10, 15)
b <- c(1, 2, 1, 1, 2)
c <- c(0, 0, 1, 1, 1)
df <- data.table::data.table("a" = a, "b" = b, "c" = c)
time1 <- "\%trunc\%"
time2 <- "a"
event <- "c"
control <- list(
  "lr" = 0.75, "maxiter" = -1, "halfmax" = 5, "epsilon" = 1e-9,
  "deriv_epsilon" = 1e-9, "abs_max" = 1.0, "change_all" = TRUE,
  "dose_abs_max" = 100.0,
  "verbose" = FALSE, "ties" = "breslow", "double_step" = 1
)
grt_f <- function(df, time_col) {
  return((df[, "b"] * df[, get(time_col)])[[1]])
}
func_form <- c("lin")
df_new <- gen_time_dep(
  df, time1, time2, event, TRUE, 0.01, c("grt"), c(),
  c(grt_f), paste("test", "_new.csv", sep = ""), func_form, 2
)
file.remove("test_new.csv")

}
\seealso{
Other Data Cleaning Functions: 
\code{\link{Check_Dupe_Columns}()},
\code{\link{Check_Trunc}()},
\code{\link{Check_Verbose}()},
\code{\link{Correct_Formula_Order}()},
\code{\link{Date_Shift}()},
\code{\link{Def_Control}()},
\code{\link{Def_Control_Guess}()},
\code{\link{Def_model_control}()},
\code{\link{Def_modelform_fix}()},
\code{\link{Joint_Multiple_Events}()},
\code{\link{Replace_Missing}()},
\code{\link{Time_Since}()},
\code{\link{factorize}()},
\code{\link{factorize_par}()},
\code{\link{interact_them}()}
}
\concept{Data Cleaning Functions}
