#' Harmonization Data
#'
#' This data set is a sample data set from ADNI study.
#'
#' @docType data
#'
#' @usage data(adni)
#'
#' @format \code{"adni"} is a data frame with 2515 cases (rows) and 104 variables
#'  (columns). 62 features are included for harmonization purpose.  
#'
#' @keywords datasets
#'
#'
#' @source \href{https://adni.loni.usc.edu/}{ADNI}
#'
#' @examples
#' data(adni)
#' head(adni)
"adni"



#' Age Trajectory Data
#'
#' This data set is used to observe life span age trend of brain structures.
#'
#' @docType data
#'
#' @usage data(age_df)
#'
#' @format \code{"age_df"} is a simulated data frame with 712 cases (rows) and 56 variables
#'  (columns). 51 rois are included.  
#'
#' @keywords datasets
#'
#'
#' @examples
#' data(age_df)
#' head(age_df)
"age_df"