% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residual_gen.R
\name{residual_gen}
\alias{residual_gen}
\title{Post Harmonization Residual Generation}
\usage{
residual_gen(
  type = "lm",
  features = NULL,
  covariates = NULL,
  interaction = NULL,
  random = NULL,
  smooth = NULL,
  smooth_int_type = NULL,
  df,
  rm = NULL,
  model = FALSE,
  model_path = NULL,
  cores = detectCores()
)
}
\arguments{
\item{type}{A model function name that is to be used (eg: \code{"lmer"}, \code{"lm"}, \code{"gam"}).}

\item{features}{The names of the features from which to extract residuals.}

\item{covariates}{Name of covariates supplied to \code{model}.}

\item{interaction}{Expression of interaction terms supplied to \code{model} (eg: \code{"age,diagnosis"}).}

\item{random}{Variable name of a random effect in linear mixed effect model.}

\item{smooth}{Variable name that requires a smooth function.}

\item{smooth_int_type}{Indicates the type of interaction in \code{gam} models. By default, \code{smooth_int_type} is set to be \code{"linear"}, representing linear interaction terms.
\code{"categorical-continuous"}, \code{"factor-smooth"} both represent categorical-continuous interactions (\code{"factor-smooth"} includes categorical variable as part of the smooth),
\code{"tensor"} represents interactions with different scales, and \code{"smooth-smooth"} represents interaction between smoothed variables.}

\item{df}{Harmonized dataset to extract residuals from.}

\item{rm}{variables to remove effects from.}

\item{model}{A boolean variable indicating whether an existing model is to be used.}

\item{model_path}{path to the existing model.}

\item{cores}{number of cores used for parallel computing.}
}
\value{
\code{residual_gen} returns a list containing the following components:
\item{model}{a list of regression models for all rois}
\item{residual}{Residual dataframe}
}
\description{
Extract residuals after harmonization.
}
\examples{
features <- colnames(adni)[43:53]
residual_gen(type = "lm", features = features,
covariates = c("AGE", "SEX", "DIAGNOSIS"), df = adni, rm = c("AGE", "SEX"), cores = 1)
}
