% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interaction.plot.R
\name{int.plot}
\alias{int.plot}
\title{Interaction plot}
\usage{
int.plot(data, outcome, predictor, moderator, y.lim = c(-1, 1),
  x.lim = c(-1, 1), x.lab = "auto", y.lab = "auto", title = "auto",
  title.size = 15, SDs = 1, legend.name = "auto", colour = "ghostwhite",
  show.points = FALSE, save = F, path = "default")
}
\arguments{
\item{data}{an object of class 'data.frame' or 'imputationList'}

\item{outcome}{a string with the name of the outcome variable}

\item{predictor}{a string with the name of the predictor variable}

\item{moderator}{a vector of the names of up to two moderating variables}

\item{y.lim}{vector of numerals indicating y axis bounds}

\item{x.lim}{vector of numerals indicating x axis bounds}

\item{x.lab}{a string with the label of the x axis}

\item{y.lab}{a string with the label of the y axis}

\item{title}{a string containing title text}

\item{title.size}{a numeral containing the font size of the title}

\item{SDs}{a numeral indicating the standard deviations of the moderators}

\item{legend.name}{a character string indicating the title of the legend}

\item{colour}{a character string containing the colour of the data points}

\item{show.points}{logical to determine whether or not to include points}

\item{save}{logical as to whether or not to save the plot}

\item{path}{string containing path of where to save plot}
}
\value{
An interaction plot
}
\description{
Calculates a two way or three way interaction and plots using ggplot2
}
\examples{
carsdata<-mtcars
int.plot(carsdata,"mpg","disp","cyl", y.lim = c(-2.5,2.5))
int.plot(carsdata,"mpg","disp", c("cyl","am"), y.lim = c(-5.0,2.0))
}

