% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlatrix.R
\name{correlatrix}
\alias{correlatrix}
\title{Correlatrix}
\usage{
correlatrix(data, var.names, triangle = "both", round = 3,
  method = "pearson", n.matrix = F, abbreviate = 100)
}
\arguments{
\item{data}{an object of class 'data.frame' or 'imputationList'}

\item{var.names}{a vector of variable names}

\item{triangle}{a string containing one of "lower" "upper" or "both". Indicates if correlations are to be displayed above or below the diagonal. "Both" is selected by default.}

\item{round}{a numeral indicating number of decimals}

\item{method}{a string containing one of "pearson","spearman" or "kendall"}

\item{n.matrix}{logical. If TRUE, matrix of n returned}

\item{abbreviate}{a number indicating the maximum length of variable names}
}
\value{
A correlation matrix
}
\description{
Takes in a data.frame or imputationList, a vector of variable names and produces a correlation matrix
}
\examples{
carsdata<-mtcars
correlatrix(carsdata,names(carsdata)[1:6],round = 2)
correlatrix(carsdata,c("mpg","cyl","disp"))
}
