% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dCount_allProbs_bi}
\alias{dCount_allProbs_bi}
\alias{dCount_allProbs_user}
\title{Compute count probabilities using simple convolution}
\usage{
dCount_allProbs_bi(x, distPars, dist, nsteps = 100L, time = 1,
  extrap = TRUE, logFlag = FALSE)

dCount_allProbs_user(x, distPars, extrapolPars, survR, nsteps = 100L,
  time = 1, extrap = TRUE, logFlag = FALSE)
}
\arguments{
\item{x}{integer (vector), the desired count values.}

\item{distPars}{\code{Rcpp::List} with distribution specific slots,
see details.}

\item{dist}{character name of the built-in distribution, see details.}

\item{nsteps}{unsiged integer number of steps used to compute the integral.}

\item{time}{double time at wich to compute the probabilities. Set to 1 by
default.}

\item{extrap}{logical if \code{TRUE}, Richardson extrapolation will be
applied to improve accuracy.}

\item{logFlag}{logical if \code{TRUE} the log-probability will be returned.}

\item{extrapolPars}{ma::vec of length 2. The extrapolation values.}

\item{survR}{Rcpp::Function user passed survival function; should have the
signature \code{function(t, distPars)} where \code{t} is a real number (>0)
where the survival function is evaluated and \code{distPars} is a list of
distribution parameters. It should return a double value.}
}
\value{
vector of probabilities P(x(i)) for i = 1, ..., n where n is
\code{length} of \code{x}.
}
\description{
Compute count probabilities using simple convolution (section 2) for the
built-in distributions

Compute count probabilities using simple convolution (section 2) for user
passed survival functions
}
\details{
The routine does convolutions to produce probabilities \code{probs(0)},
... \code{probs(xmax)} using \code{nsteps} steps, and refines result by
Richardson extrapolation if \code{extrap} is \code{TRUE} using the
algorithm of section 2.
}
\keyword{internal}
