% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/library--data_prep--calculated_tools--date_vector_difference.R
\name{date_distance_clamp}
\alias{date_distance_clamp}
\title{remove distances above threshold}
\usage{
date_distance_clamp(DF, vecNames, thresh)
}
\arguments{
\item{DF}{source dataframe}

\item{vecNames}{column names in DF to be modified}

\item{thresh}{max distance not reduced to thresh from data}
}
\value{
DF with distances above threshold clamped to threshold
}
\description{
remove distances above threshold
}
\examples{
data("Example_data", package = "Covid19Wastewater")
Example_data$Late_date <- sample(Example_data$date)
Example_data$Late_date[sample(1:length(Example_data), length(Example_data) / 3)] <- NA
df <- date_distance_calc(Example_data, "date", "Late_date")
}
