% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manualrotate.R
\name{manualrotate}
\alias{manualrotate}
\title{Manual calculation of land cover changes}
\usage{
manualrotate(datat1, datat2)
}
\arguments{
\item{datat1}{A raster file.}

\item{datat2}{A raster file.}
}
\value{
The function returns a data frame.
}
\description{
The \code{manualrotate} function analyzes land cover changes based on two raster files from the CropScape. The analysis is done in three steps.
 At step 1, the two raster files are converted to data tables. At step 2, the two data tables are merged together based on their coordinates.
 The coordinates without macthes are discarded during the merging process.
 At step 3, the merged data are aggregated by counting the number of pixels for each land cover change group.
}
\examples{
\donttest{
# Calculate land cover changes for the Champaign county (FIPS = 17109) in 2017-2018.
datat1 <- GetCDLData(aoi = '17019', year = 2017, type = 'f')
datat2 <- GetCDLData(aoi = '17019', year = 2018, type = 'f')
change <- manualrotate(datat1, datat2)
}

}
