% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_rates.R
\name{get_clado_rate_per_capita}
\alias{get_clado_rate_per_capita}
\title{Calculate per-capita cladogenesis rate}
\usage{
get_clado_rate_per_capita(lac, d, num_spec, K, A = 1)
}
\arguments{
\item{lac}{A numeric with the per capita cladogenesis rate.}

\item{d}{Numeric defining the scaling parameter for exponent for
calculating cladogenesis rate.}

\item{num_spec}{A numeric with the current number of species.}

\item{K}{A numeric with carrying capacity.}

\item{A}{A numeric value for island area at a given point in time.}
}
\value{
Numeric with the per-capita cladogenesis rate given a base
cladogenesis rate, K, A and the d hyperparameter.
}
\description{
This function is only called directly inside the RHS of the ontogeny
likelihood functions. In all other cases \code{\link{get_clado_rate}()} is to
be called instead.
}
\examples{
lac <- 0.4
d <- 0
num_spec <- 2
K <- 10
A <- 1
clado_rate_pc <- DAISIE:::get_clado_rate_per_capita(lac, d, num_spec, K, A)
}
\keyword{internal}
