% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_feature.R
\name{model_feature_response}
\alias{model_feature_response}
\alias{model_feature_response.explainer}
\alias{model_feature_response.default}
\title{Marginal Response for a Single Variable}
\usage{
model_feature_response(x, ...)

\method{model_feature_response}{explainer}(x, feature, type = "pdp",
  which_class = NULL, ...)

\method{model_feature_response}{default}(x, data, predict_function,
  feature, type = "pdp", label = class(x)[1], which_class = NULL,
  ...)
}
\arguments{
\item{x}{a model to be explained, or an explainer created with function `DALEX::explain()`.}

\item{...}{other parameters}

\item{feature}{character - name of a single variable}

\item{type}{character - type of the response to be calculated.
Currently following options are implemented: 'pdp' for Partial Dependency and 'ale' for Accumulated Local Effects}

\item{which_class}{character, for multilabel classification you can restrict results to selected classes. By default `NULL` which means that all classes are considered.}

\item{data}{validation dataset, will be extracted from `x` if it's an explainer}

\item{predict_function}{predict function, will be extracted from `x` if it's an explainer}

\item{label}{name of the model. By default it's extracted from the 'class' attribute of the model}
}
\value{
An object of the class 'model_feature_response_explainer'.
It's a data frame with calculated average response.
}
\description{
Calculates the average model response as a function of a single selected variable.
Use the 'type' parameter to select the type of marginal response to be calculated.
Currently for numeric variables we have Partial Dependency and Accumulated Local Effects implemented.
Current implementation uses the 'pdp' package (Brandon M. Greenwell (2017).
pdp: An R Package for Constructing Partial Dependence Plots. The R Journal, 9(1), 421--436.)
and 'ALEPlot' (Dan Apley (2017). ALEPlot: Accumulated Local Effects Plots and Partial Dependence Plots.)
}
\details{
For factor variables we are using the 'factorMerger' package.
Please note that the argument \code{type} must be set to \code{'factor'} to use this method.
}
\examples{
library("DALEX")

HR_glm_model <- glm(status == "fired" ~ ., data = HR, family = "binomial")
explainer_glm <- explain(HR_glm_model, data = HR)
expl_glm <- model_feature_response(explainer_glm, "age", "pdp")
head(expl_glm)
plot(expl_glm)

 \dontrun{
library("randomForest")
HR_rf_model <- randomForest(status ~ ., data = HR, ntree = 100)
explainer_rf  <- explain(HR_rf_model, data = HR)
expl_rf  <- model_feature_response(explainer_rf, feature = "age", type = "pdp")
head(expl_rf)
plot(expl_rf)

expl_rf  <- model_feature_response(explainer_rf, feature = "age", type = "pdp",
                       which_class = 2)
plot(expl_rf)
 }

}
\references{
Predictive Models: Visual Exploration, Explanation and Debugging \url{https://pbiecek.github.io/PM_VEE/}
}
