% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.explainer}
\alias{predict.explainer}
\alias{model_prediction}
\title{Predictions for the Explainer}
\usage{
\method{predict}{explainer}(object, newdata, ...)

model_prediction(explainer, new_data, ...)
}
\arguments{
\item{object}{a model to be explained, object of the class \code{explainer}}

\item{newdata}{data.frame or matrix - observations for prediction}

\item{...}{other parameters that will be passed to the predict function}

\item{explainer}{a model to be explained, object of the class \code{explainer}}

\item{new_data}{data.frame or matrix - observations for prediction}
}
\value{
An numeric matrix of predictions
}
\description{
This is a generic \code{predict()} function works for \code{explainer} objects.
}
\examples{
HR_glm_model <- glm(status == "fired"~., data = HR, family = "binomial")
explainer_glm <- explain(HR_glm_model, data = HR)
predict(explainer_glm, HR[1:3,])

 \dontrun{
library("ranger")
HR_ranger_model <- ranger(status~., data = HR, num.trees = 50, probability = TRUE)
explainer_ranger  <- explain(HR_ranger_model, data = HR)
predict(explainer_ranger, HR[1:3,])

model_prediction(explainer_ranger, HR[1:3,])
 }
}
