% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/training_test_comparison.R
\name{training_test_comparison}
\alias{training_test_comparison}
\title{Compare performance of model between training and test set}
\usage{
training_test_comparison(
  champion,
  challengers,
  training_data,
  training_y,
  measure_function = NULL
)
}
\arguments{
\item{champion}{- explainer of champion model.}

\item{challengers}{- explainer of challenger model or list of explainers.}

\item{training_data}{- data without target column that will be passed to predict function and then to measure function. Keep in mind that
they have to differ from data passed to an explainer.}

\item{training_y}{- target column for \code{training_data}}

\item{measure_function}{- measure function that calculates performance of model based on true observation and prediction.
Order of parameters is important and should be (y, y_hat). By default it is RMSE.}
}
\value{
An object of the class \code{training_test_comparison}.

It is a named list containig:
\itemize{
\item \code{data} data.frame with following columns
  \itemize{
  \item \code{measure_test} performance on test set
  \item \code{measure_train} performance on training set
  \item \code{label} label of explainer
  \item \code{type} flag that indicates if explainer was passed as champion or as challenger.
}
\item \code{models_info} data.frame containig inforamtion about models used in analysys
}
}
\description{
Function \code{training_test_comparison} calculates performance of the provided model based on specified measure function.
Response of the model is caluclated based on test data, extracted from the explainer and training data, provided by the user.
Output can be easily shown with \code{print} or \code{plot} function.
}
\examples{
library("mlr")
library("DALEXtra")
task <- mlr::makeRegrTask(
 id = "R",
  data = apartments,
   target = "m2.price"
)
 learner_lm <- mlr::makeLearner(
 "regr.lm"
)
model_lm <- mlr::train(learner_lm, task)
explainer_lm <- explain_mlr(model_lm, apartmentsTest, apartmentsTest$m2.price, label = "LM")

learner_rf <- mlr::makeLearner(
"regr.randomForest"
)
model_rf <- mlr::train(learner_rf, task)
explainer_rf <- explain_mlr(model_rf, apartmentsTest, apartmentsTest$m2.price, label = "RF")

learner_gbm <- mlr::makeLearner(
"regr.gbm"
)
model_gbm <- mlr::train(learner_gbm, task)
explainer_gbm <- explain_mlr(model_gbm, apartmentsTest, apartmentsTest$m2.price, label = "GBM")

data <- training_test_comparison(explainer_lm, list(explainer_gbm, explainer_rf),
                                 training_data = apartments,
                                 training_y = apartments$m2.price)
plot(data)
}
