% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{DAintfun3}
\alias{DAintfun3}
\title{Conditional Effects Plots for Interactions in Linear Models}
\usage{
DAintfun3(
  obj,
  varnames,
  varcov = NULL,
  name.stem = "cond_eff",
  xlab = NULL,
  ylab = NULL,
  plot.type = "screen"
)
}
\arguments{
\item{obj}{A model object of class \code{lm}}

\item{varnames}{A two-element character vector where each element is the
name of a variable involved in a two-way interaction.}

\item{varcov}{A variance-covariance matrix with which to calculate the
conditional standard errors.  If \code{NULL}, it is calculated with
\code{vcov(obj)}.}

\item{name.stem}{A character string giving filename to which the appropriate
extension will be appended}

\item{xlab}{Optional vector of length two giving the x-labels for the two
plots that are generated.  The first element of the vector corresponds to
the figure plotting the conditional effect of the first variable in
\code{varnames} given the second and the second element of the vector
corresponds to the figure plotting the conditional effect of the second
variable in \code{varnames} conditional on the first.}

\item{ylab}{Optional vector of length two giving the y-labels for the two
plots that are generated.  The first element of the vector corresponds to
the figure plotting the conditional effect of the first variable in
\code{varnames} given the second and the second element of the vector
corresponds to the figure plotting the conditional effect of the second
variable in \code{varnames} conditional on the first.}

\item{plot.type}{One of \sQuote{pdf}, \sQuote{png}, \sQuote{eps} or
\sQuote{screen}, where the one of the first three will produce two graphs
starting with \code{name.stem} written to the appropriate file type and the
third will produce graphical output on the screen.}
}
\value{
\item{graphs}{Either a single graph is printed on the screen (using
\code{par(mfrow=c(1,2))}) or two figures starting with \code{name.stem} are
produced where each gives the conditional effect of one variable based on
the values of another.}
}
\description{
Generates two conditional effects plots for two interacted continuous
covariates in linear models.
}
\details{
This function does the same thing as \code{\link{DAintfun2}}, but presents
effects only at the mean of the conditioning variable and the mean +/- 1
standard deviation.
}
\examples{

data(InteractionEx)
mod <- lm(y ~ x1*x2 + z, data=InteractionEx)
DAintfun3(mod, c("x1", "x2"))

}
\references{
Brambor, T., W.R. Clark and M. Golder.  (2006) Understanding
Interaction Models: Improving Empirical Analyses.  Political Analysis 14,
63-82.\cr Berry, W., M. Golder and D. Milton.  (2012) Improving Tests of
Theories Positing Interactions.  Journal of Politics.
}
\author{
Dave Armstrong
}
