\name{pre}
\alias{pre}
\title{Proportional and Expected Proportional Reductions in Error}
\description{Calculates proportional reduction in error (PRE) and expected proportional reduction in error (epre) from Herron (1999).}
\usage{
pre(mod1, mod2=NULL, sim=FALSE, R=2500)
}
\arguments{
  \item{mod1}{A model of class \code{glm} (with family \code{binomial}), \code{polr} or \code{multinom} for which (e)PRE will be calculated.}
  \item{mod2}{A model of the same class as \code{mod1} against which proportional reduction in error will be measured.  If \code{NULL}, the null model will be used.}
  \item{sim}{A logical argument indicating whether a parametric bootstrap should be used to calculate confidence bounds for (e)PRE.  See \code{Details} for more information.}
  \item{R}{Number of bootstrap samples to be drawn if \code{sim=TRUE}.}
}
\details{
Proportional reduction in error is calculated as a function of correct and incorrect predictions (and the probabilities of correct and incorrect predictions for ePRE).  When \code{sim=TRUE}, a parametric bootstrap will be used that draws from the multivariate normal distribution centered at the coefficient estimates from the model and using the estimated variance-covariance matrix of the estimators as Sigma.  This matrix is used to form \code{R} versions of XB and predictions are made for each of the \code{R} different versions of XB.  Confidence intervals can then be created from the bootstrap sampled (e)PRE values. 
}
\value{
An object of class \code{pre}, which is a list with the following elements: 
  \item{pre}{The proportional reduction in error}
  \item{epre}{The expected proportional reduction in error}
  \item{m1form}{The formula for model 1}
  \item{m2form}{The formula for model 2}
  \item{pcp}{The percent correctly predicted by model 1}
  \item{pmc}{The percent correctly predicted by model 2}
  \item{epcp}{The expected percent correctly predicted by model 1}
  \item{epmc}{The expected percent correctly predicted by model 2}
  \item{pre.sim}{A vector of bootstrapped PRE values if \code{sim=TRUE}}
  \item{epre.sim}{A vector of bootstrapped ePRE values if \code{sim=TRUE}}
}
\references{
Herron, M.  1999.  Postestimation Uncertainty in Limited Dependent Variable Models.  Political Analysis 8(1): 83--98. 
}
\author{Dave Armstrong}
\examples{
data(france)
left.mod <- glm(voteleft ~ male + age + retnat + 
	poly(lrself, 2), data=france, family=binomial)
pre(left.mod)
}
