% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBDriver.R
\name{dbDriver}
\alias{dbDriver}
\alias{dbUnloadDriver}
\title{Load and unload database drivers}
\usage{
dbDriver(drvName, ...)

dbUnloadDriver(drv, ...)
}
\arguments{
\item{drvName}{character name of the driver to instantiate.}

\item{...}{any other arguments are passed to the driver \code{drvName}.}

\item{drv}{an object that inherits from \code{DBIDriver} as created by
\code{dbDriver}.}
}
\value{
In the case of \code{dbDriver}, an driver object whose class extends
\code{DBIDriver}. This object may be used to create connections to the
actual DBMS engine.

In the case of \code{dbUnloadDriver}, a logical indicating whether the
operation succeeded or not.
}
\description{
These methods are deprecated, please consult the documentation of the
individual backends for the construction of driver instances.

\code{dbDriver()} is a helper method used to create an new driver object
given the name of a database or the corresponding R package. It works
through convention: all DBI-extending packages should provide an exported
object with the same name as the package. \code{dbDriver()} just looks for
this object in the right places: if you know what database you are connecting
to, you should call the function directly.

\code{dbUnloadDriver()} is not implemented for modern backends.
}
\details{
The client part of the database communication is
initialized (typically dynamically loading C code, etc.) but note that
connecting to the database engine itself needs to be done through calls to
\code{dbConnect}.
}
\examples{
# Create a RSQLite driver with a string
d <- dbDriver("SQLite")
d

# But better, access the object directly
RSQLite::SQLite()
}
\seealso{
Other DBIDriver generics: \code{\link{DBIDriver-class}},
  \code{\link{dbConnect}}, \code{\link{dbDataType}},
  \code{\link{dbGetInfo}}, \code{\link{dbIsValid}},
  \code{\link{dbListConnections}}

Other DBIDriver generics: \code{\link{DBIDriver-class}},
  \code{\link{dbConnect}}, \code{\link{dbDataType}},
  \code{\link{dbGetInfo}}, \code{\link{dbIsValid}},
  \code{\link{dbListConnections}}
}
\concept{DBIDriver generics}
