% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H-Test.R
\name{perform_h_test}
\alias{perform_h_test}
\title{Function for Half's-T-Test Analysis}
\usage{
perform_h_test(con, exp, alpha = 0.05, FC)
}
\arguments{
\item{con}{A data frame or matrix containing the expression values for the control.}

\item{exp}{A data frame or matrix containing the expression values for the experiment.}

\item{alpha}{Value of significance level ranging from 0 to 1 (default = 0.05 states 5 \% significance).}

\item{FC}{An array  or list containing fold change values for each gene, calculated by}
}
\value{
A data frame containing values for statistic score, p-values etc for each gene being tested.
}
\description{
Function for Half's-T-Test Analysis
}
\examples{
library(DGEAR)
data("gene_exp_data")
data = read_and_preprocess_data(datafile = gene_exp_data, con1=1,con2=10,exp1=11,exp2=20)
perform_h_test(con= data$con, exp= data$exp, FC = data$FC)
}
