% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_database.R
\name{query_database}
\alias{query_database}
\title{query_database helper function}
\usage{
query_database(
  db_con,
  sql_statement,
  no_result = FALSE,
  close_connection = FALSE
)
}
\arguments{
\item{db_con}{A DBI database connection.}

\item{sql_statement}{A character string containing a valid SQL statement.
Caution: Everything after the first ';' will be cut off.}

\item{no_result}{(boolean, default: FALSE) Is the sql meant to return
nothing? E.g. if you just insert or update a table.
Then supply `TRUE` here. If you supply `FALSE` here, the
function expects to receive a result table and tries to convert it
to a data.table.}

\item{close_connection}{(boolean, default = FALSE). If TRUE, the connection
will be closed after the query was sent and the result received.}
}
\value{
Returns the result of the db-query. If `no_result` is `TRUE`,
 the return value will be `TRUE` if the query was successfully sent.
 Otherwise (if `no_result` is `FALSE` which is the default), the result
 will be the result of the sql query as data.table.
}
\description{
Internal function to query the database. The function
  sends a sql statement to the database and returns a data.table.
}
\examples{
\dontrun{
db_con <- DIZutils::db_connection(
  db_name = "i2b2",
  db_type = "postgres"
)

query_database(
  db_con = db_con,
  sql_statement = "SELECT * FROM table_name;"
)

query_database(
  db_con = db_con,
  sql_statement = "INSERT INTO table_name DEFAULT VALUES;",
  no_result = TRUE
)

}

}
